/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.conversation;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

@SuppressWarnings(value={"SE_BAD_FIELD"}, justification="InstanceImpl, which we actually use, is serializable")
public class ConversationImpl
implements ManagedConversation,
Serializable {
    private static final long serialVersionUID = 8873338254645033645L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private String id;
    private boolean _transient;
    private long timeout;
    private ReentrantLock concurrencyLock;
    private long lastUsed;
    private final Instance<ConversationContext> conversationContexts;

    @Inject
    public ConversationImpl(Instance<ConversationContext> conversationContexts) {
        this.conversationContexts = conversationContexts;
        this._transient = true;
        ConversationContext conversationContext = this.getConversationContext();
        this.timeout = conversationContext != null ? conversationContext.getDefaultTimeout() : 0L;
        this.concurrencyLock = new ReentrantLock();
        this.touch();
    }

    private ConversationContext getConversationContext() {
        for (ConversationContext conversationContext : this.conversationContexts) {
            if (!conversationContext.isActive()) continue;
            return conversationContext;
        }
        return null;
    }

    public void begin() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        this._transient = false;
        if (this.id == null) {
            this.id = this.getConversationContext().generateConversationId();
        }
        log.debug((Enum)ConversationMessage.PROMOTED_TRANSIENT, new Object[]{this.id});
    }

    public void begin(String id) {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw new IllegalStateException(ConversationMessage.BEGIN_CALLED_ON_LONG_RUNNING_CONVERSATION, new Object[0]);
        }
        if (this.getConversationContext().getConversation(id) != null) {
            throw new IllegalArgumentException(ConversationMessage.CONVERSATION_ID_ALREADY_IN_USE, id);
        }
        this._transient = false;
        this.id = id;
        log.debug((Enum)ConversationMessage.PROMOTED_TRANSIENT, new Object[]{id});
    }

    public void end() {
        this.verifyConversationContextActive();
        if (this._transient) {
            throw new IllegalStateException(ConversationMessage.END_CALLED_ON_TRANSIENT_CONVERSATION, new Object[0]);
        }
        log.debug((Enum)ConversationMessage.DEMOTED_LRC, new Object[]{this.id});
        this._transient = true;
    }

    public String getId() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            return this.id;
        }
        return null;
    }

    public long getTimeout() {
        this.verifyConversationContextActive();
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.verifyConversationContextActive();
        this.timeout = timeout;
    }

    public String toString() {
        if (this._transient) {
            return "Transient conversation";
        }
        return "Conversation with id: " + this.id;
    }

    public boolean isTransient() {
        this.verifyConversationContextActive();
        return this._transient;
    }

    public long getLastUsed() {
        this.verifyConversationContextActive();
        return this.lastUsed;
    }

    public void touch() {
        this.verifyConversationContextActive();
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean lock(long timeout) {
        boolean success;
        this.verifyConversationContextActive();
        try {
            success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            success = false;
        }
        if (success) {
            log.trace((Enum)ConversationMessage.CONVERSATION_LOCKED, new Object[]{this});
        } else {
            log.warn((Enum)ConversationMessage.CONVERSATION_UNAVAILABLE, new Object[]{timeout, this});
        }
        return success;
    }

    public boolean unlock() {
        this.verifyConversationContextActive();
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace((Enum)ConversationMessage.CONVERSATION_UNLOCKED, new Object[]{this});
        } else {
            log.warn((Enum)ConversationMessage.ILLEGAL_CONVERSATION_UNLOCK_ATTEMPT, new Object[]{this, "not owner"});
        }
        return !this.concurrencyLock.isLocked();
    }

    private void verifyConversationContextActive() {
        ConversationContext ctx = this.getConversationContext();
        if (ctx == null) {
            throw new ContextNotActiveException("Conversation Context not active when method called on conversation " + this);
        }
    }
}

