/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.executor.AbstractExecutorServices;
import org.jboss.weld.executor.DeamonThreadFactory;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.slf4j.cal10n.LocLogger;

public class TimingOutFixedThreadPoolExecutorServices
extends AbstractExecutorServices {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final int threadPoolSize;
    private long keepAliveTime;
    private final ThreadPoolExecutor executor;

    public TimingOutFixedThreadPoolExecutorServices(int threadPoolSize, long keepAliveTime) {
        this.threadPoolSize = threadPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DeamonThreadFactory(new ThreadGroup("weld-workers"), "weld-worker-"));
        this.executor.allowCoreThreadTimeOut(true);
        log.debug((Enum)BootstrapMessage.THREADS_IN_USE, new Object[]{threadPoolSize});
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public ExecutorService getTaskExecutor() {
        return this.executor;
    }

    @Override
    protected int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public String toString() {
        return String.format("TimingOutFixedThreadPoolExecutorServices [threadPoolSize=%s, keepAliveTime=%s]", this.threadPoolSize, this.keepAliveTime);
    }
}

