/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.util.reflection.Reflections;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
WeldCreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 7375854583908262422L;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private transient Map<Contextual<?>, Object> incompleteInstances;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Not needed after initial creation")
    private final transient Contextual<T> contextual;
    private final List<ContextualInstance<?>> dependentInstances;
    private final List<ContextualInstance<?>> parentDependentInstances;
    private final CreationalContextImpl<?> parentCreationalContext;
    private transient List<ResourceReference<?>> resourceReferences;
    private boolean constructorInterceptionSuppressed;
    private transient List<AroundConstructCallback<T>> aroundConstructCallbacks;

    public CreationalContextImpl(Contextual<T> contextual) {
        this(contextual, null, Collections.synchronizedList(new ArrayList()), null);
    }

    private CreationalContextImpl(Contextual<T> contextual, Map<Contextual<?>, Object> incompleteInstances, List<ContextualInstance<?>> parentDependentInstancesStore, CreationalContextImpl<?> parentCreationalContext) {
        this.incompleteInstances = incompleteInstances;
        this.contextual = contextual;
        this.dependentInstances = Collections.synchronizedList(new ArrayList());
        this.parentDependentInstances = parentDependentInstancesStore;
        this.parentCreationalContext = parentCreationalContext;
        this.constructorInterceptionSuppressed = false;
    }

    public void push(T incompleteInstance) {
        if (this.incompleteInstances == null) {
            this.incompleteInstances = new HashMap();
        }
        this.incompleteInstances.put(this.contextual, incompleteInstance);
    }

    @Override
    public <S> CreationalContextImpl<S> getCreationalContext(Contextual<S> contextual) {
        return new CreationalContextImpl<S>(contextual, this.incompleteInstances, this.dependentInstances, this);
    }

    @Override
    public <S> S getIncompleteInstance(Contextual<S> bean) {
        return this.incompleteInstances == null ? null : (S)Reflections.cast(this.incompleteInstances.get(bean));
    }

    @Override
    public boolean containsIncompleteInstance(Contextual<?> bean) {
        return this.incompleteInstances != null && this.incompleteInstances.containsKey(bean);
    }

    @Override
    public void addDependentInstance(ContextualInstance<?> contextualInstance) {
        this.parentDependentInstances.add(contextualInstance);
    }

    @Override
    public void release() {
        this.release(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Contextual<T> contextual, T instance) {
        List<ContextualInstance<?>> list = this.dependentInstances;
        synchronized (list) {
            for (ContextualInstance<?> dependentInstance : this.dependentInstances) {
                if (contextual != null && dependentInstance.getContextual().equals(contextual)) continue;
                CreationalContextImpl.destroy(dependentInstance);
            }
        }
        if (this.resourceReferences != null) {
            for (ResourceReference<?> reference : this.resourceReferences) {
                reference.release();
            }
        }
    }

    private static <T> void destroy(ContextualInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    @Override
    public CreationalContextImpl<?> getParentCreationalContext() {
        return this.parentCreationalContext;
    }

    @Override
    public List<ContextualInstance<?>> getDependentInstances() {
        return Collections.unmodifiableList(this.dependentInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object writeReplace() throws ObjectStreamException {
        List<ContextualInstance<?>> list = this.dependentInstances;
        synchronized (list) {
            Iterator<ContextualInstance<?>> iterator = this.dependentInstances.iterator();
            while (iterator.hasNext()) {
                ContextualInstance<?> instance = iterator.next();
                if (instance.getInstance() instanceof Serializable) continue;
                CreationalContextImpl.destroy(instance);
                iterator.remove();
            }
        }
        return this;
    }

    @Override
    public void addDependentResourceReference(ResourceReference<?> resourceReference) {
        if (this.resourceReferences == null) {
            this.resourceReferences = new ArrayList();
        }
        this.resourceReferences.add(resourceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyDependentInstance(T instance) {
        List<ContextualInstance<?>> list = this.dependentInstances;
        synchronized (list) {
            Iterator<ContextualInstance<?>> iterator = this.dependentInstances.iterator();
            while (iterator.hasNext()) {
                ContextualInstance<?> contextualInstance = iterator.next();
                if (!contextualInstance.getInstance().equals(instance)) continue;
                iterator.remove();
                CreationalContextImpl.destroy(contextualInstance);
                return true;
            }
        }
        return false;
    }

    @Override
    public Contextual<T> getContextual() {
        return this.contextual;
    }

    public List<AroundConstructCallback<T>> getAroundConstructCallbacks() {
        if (this.aroundConstructCallbacks == null) {
            return Collections.emptyList();
        }
        return this.aroundConstructCallbacks;
    }

    public void setConstructorInterceptionSuppressed(boolean value) {
        this.constructorInterceptionSuppressed = value;
    }

    public boolean isConstructorInterceptionSuppressed() {
        return this.constructorInterceptionSuppressed;
    }

    public void registerAroundConstructCallback(AroundConstructCallback<T> callback) {
        if (this.aroundConstructCallbacks == null) {
            this.aroundConstructCallbacks = new LinkedList<AroundConstructCallback<T>>();
        }
        this.aroundConstructCallbacks.add(callback);
    }
}

