/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.EventPacket;
import org.jboss.weld.event.TransactionalObserverNotifier;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private static final RuntimeException NO_EXCEPTION_MARKER = new RuntimeException();
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;
    private final boolean strict;
    protected final CurrentEventMetadata currentEventMetadata;
    private final LoadingCache<Type, RuntimeException> eventTypeCheckCache;

    public static ObserverNotifier of(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        if (services.contains(TransactionServices.class)) {
            return new TransactionalObserverNotifier(contextId, resolver, services, strict);
        }
        return new ObserverNotifier(resolver, services, strict);
    }

    protected ObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        this.resolver = resolver;
        this.sharedObjectCache = (SharedObjectCache)services.get(SharedObjectCache.class);
        this.strict = strict;
        this.currentEventMetadata = (CurrentEventMetadata)services.get(CurrentEventMetadata.class);
        this.eventTypeCheckCache = strict ? CacheBuilder.newBuilder().build((CacheLoader)new EventTypeCheck()) : null;
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        this.checkEventObjectType(event);
        return this.resolveObserverMethods(this.buildEventResolvable(event.getClass(), bindings));
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        this.notifyObservers(event, this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers)));
    }

    public void fireEvent(Object event, Resolvable resolvable) {
        this.checkEventObjectType(event);
        this.notifyObservers(event, this.resolveObserverMethods(resolvable));
    }

    public <T> void fireEvent(EventPacket<T> packet) {
        this.checkEventObjectType(packet.getType());
        this.notifyObservers((T)packet, this.resolveObserverMethods(packet.getResolvable()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void notifyObservers(EventPacket<T> eventPacket, Set<ObserverMethod<? super T>> observers) {
        this.currentEventMetadata.push(eventPacket);
        try {
            for (ObserverMethod<T> observerMethod : observers) {
                this.notifyObserver((T)eventPacket, (ObserverMethod<? super T>)observerMethod);
            }
        }
        finally {
            this.currentEventMetadata.pop();
        }
    }

    private <T> void notifyObservers(T event, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observerMethod : observers) {
            this.notifyObserver(event, observerMethod);
        }
    }

    public Resolvable buildEventResolvable(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosureHolder(eventType).get();
        return new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent((Annotation)AnyLiteral.INSTANCE).create();
    }

    public Resolvable buildEventResolvable(Type eventType, Annotation ... qualifiers) {
        return new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(this.sharedObjectCache.getTypeClosureHolder(eventType).get()).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent((Annotation)AnyLiteral.INSTANCE).create();
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Resolvable resolvable) {
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void clear() {
        this.resolver.clear();
        if (this.eventTypeCheckCache != null) {
            this.eventTypeCheckCache.invalidateAll();
        }
    }

    protected <T> void notifyObserver(EventPacket<T> eventPacket, ObserverMethod<? super T> observer) {
        this.notifyObserver(eventPacket.getPayload(), observer);
    }

    protected <T> void notifyObserver(T event, ObserverMethod<? super T> observer) {
        observer.notify(event);
    }

    public void checkEventObjectType(Object event) {
        this.checkEventObjectType(event.getClass());
    }

    public void checkEventObjectType(Type eventType) {
        RuntimeException exception;
        if (this.strict && (exception = LoadingCacheUtils.getCacheValue(this.eventTypeCheckCache, eventType)) != NO_EXCEPTION_MARKER) {
            throw exception;
        }
    }

    private class EventTypeCheck
    extends CacheLoader<Type, RuntimeException> {
        private EventTypeCheck() {
        }

        public RuntimeException load(Type eventType) {
            Type resolvedType = Types.getCanonicalType(eventType);
            if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
                return UtilLogger.LOG.typeParameterNotAllowedInEventType(eventType);
            }
            Class resolvedClass = Reflections.getRawType(eventType);
            for (Class clazz : Observers.CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES) {
                if (!clazz.isAssignableFrom(resolvedClass)) continue;
                return UtilLogger.LOG.eventTypeNotAllowed(eventType);
            }
            return NO_EXCEPTION_MARKER;
        }
    }
}

