/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.MissingDependenciesRegistry;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SyntheticExtension;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class ExtensionBeanDeployer {
    private final BeanManagerImpl beanManager;
    private final Set<Metadata<? extends Extension>> extensions;
    private final Deployment deployment;
    private final BeanDeploymentArchiveMapping bdaMapping;
    private final Collection<ContextHolder<? extends Context>> contexts;
    private final ContainerLifecycleEvents containerLifecycleEventObservers;
    private final MissingDependenciesRegistry missingDependenciesRegistry;

    public ExtensionBeanDeployer(BeanManagerImpl manager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        this.beanManager = manager;
        this.extensions = new HashSet<Metadata<? extends Extension>>();
        this.deployment = deployment;
        this.bdaMapping = bdaMapping;
        this.contexts = contexts;
        this.containerLifecycleEventObservers = (ContainerLifecycleEvents)this.beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.missingDependenciesRegistry = (MissingDependenciesRegistry)this.beanManager.getServices().get(MissingDependenciesRegistry.class);
    }

    public ExtensionBeanDeployer deployBeans() {
        ClassTransformer classTransformer = (ClassTransformer)this.beanManager.getServices().get(ClassTransformer.class);
        for (Metadata<? extends Extension> extension : this.extensions) {
            this.deployBean(extension, classTransformer);
        }
        return this;
    }

    private <E extends Extension> void deployBean(Metadata<E> extension, ClassTransformer classTransformer) {
        BeanDeployment beanDeployment = DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.beanManager, this.bdaMapping, this.contexts, ((Extension)extension.getValue()).getClass());
        if (extension.getValue() instanceof SyntheticExtension) {
            SyntheticExtension synthetic = (SyntheticExtension)extension.getValue();
            synthetic.initialize((BeanManager)beanDeployment.getBeanManager());
            for (ObserverMethod observerMethod : synthetic.getObservers()) {
                beanDeployment.getBeanManager().addObserver(observerMethod);
                this.containerLifecycleEventObservers.processObserverMethod(observerMethod);
            }
            return;
        }
        EnhancedAnnotatedType<E> enchancedAnnotatedType = this.getEnhancedAnnotatedType(classTransformer, extension, beanDeployment);
        if (enchancedAnnotatedType != null) {
            ExtensionBean<E> bean = new ExtensionBean<E>(beanDeployment.getBeanManager(), enchancedAnnotatedType, extension);
            HashSet hashSet = new HashSet();
            this.createObserverMethods(bean, beanDeployment.getBeanManager(), enchancedAnnotatedType, hashSet);
            beanDeployment.getBeanManager().addBean(bean);
            beanDeployment.getBeanDeployer().addExtension(bean);
            for (ObserverInitializationContext observerInitializationContext : hashSet) {
                observerInitializationContext.initialize();
                beanDeployment.getBeanManager().addObserver(observerInitializationContext.getObserver());
                this.containerLifecycleEventObservers.processObserverMethod(observerInitializationContext.getObserver());
            }
            BootstrapLogger.LOG.extensionBeanDeployed(bean);
        }
    }

    private <E extends Extension> EnhancedAnnotatedType<E> getEnhancedAnnotatedType(ClassTransformer classTransformer, Metadata<E> extension, BeanDeployment beanDeployment) {
        Class<?> clazz = ((Extension)extension.getValue()).getClass();
        try {
            return (EnhancedAnnotatedType)Reflections.cast(classTransformer.getEnhancedAnnotatedType(clazz, beanDeployment.getBeanDeploymentArchive().getId()));
        }
        catch (ResourceLoadingException e) {
            String missingDependency = Formats.getNameOfMissingClassLoaderDependency(e);
            BootstrapLogger.LOG.ignoringExtensionClassDueToLoadingError(clazz.getName(), missingDependency);
            BootstrapLogger.LOG.catchingDebug(e);
            this.missingDependenciesRegistry.registerClassWithMissingDependency(clazz.getName(), missingDependency);
            return null;
        }
    }

    public void addExtensions(Iterable<Metadata<? extends Extension>> extensions) {
        for (Metadata<? extends Extension> extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Metadata<? extends Extension> extension) {
        this.extensions.add(extension);
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedType<? super X> annotatedClass, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, beanManager, enhancedAnnotatedMethod, observerMethodInitializers, false);
        }
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getAsyncObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, beanManager, enhancedAnnotatedMethod, observerMethodInitializers, true);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, BeanManagerImpl beanManager, EnhancedAnnotatedMethod<T, ? super X> method, Set<ObserverInitializationContext<?, ?>> observerMethodInitializers, boolean isAsync) {
        ObserverMethodImpl<T, X> observer = ObserverFactory.create(method, declaringBean, beanManager, isAsync);
        ObserverInitializationContext<T, ? super X> observerMethodInitializer = ObserverInitializationContext.of(observer, method);
        if (isAsync && Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(observer.getObservedType()))) {
            throw EventLogger.LOG.asyncContainerLifecycleEventObserver(observer, Formats.formatAsStackTraceElement(method.getJavaMember()));
        }
        observerMethodInitializers.add(observerMethodInitializer);
    }
}

