/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.builder.ObserverMethodConfigurator;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.builder.ObserverMethodBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.ObserverMethodConfiguratorImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;

public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> initialObserverMethod;
    private ObserverMethod<T> observerMethod;
    private ObserverMethodConfiguratorImpl<T> configurator;
    private boolean vetoed;
    private boolean observerMethodSet;

    public static <T, X> ObserverMethod<T> fire(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        ProcessObserverMethodImpl event = new ProcessObserverMethodImpl<T, X>(beanManager, (AnnotatedMethod)beanMethod, (ObserverMethod)observerMethod){};
        event.fire();
        if (event.vetoed) {
            return null;
        }
        return event.observerMethod;
    }

    private ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        super(beanManager, (Type)((Object)ProcessObserverMethod.class), new Type[]{observerMethod.getObservedType(), observerMethod.getBeanClass()});
        this.beanMethod = beanMethod;
        this.initialObserverMethod = observerMethod;
        this.observerMethod = observerMethod;
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        this.checkWithinObserverNotification();
        return this.beanMethod;
    }

    public ObserverMethod<T> getObserverMethod() {
        this.checkWithinObserverNotification();
        return this.observerMethod;
    }

    public void setObserverMethod(ObserverMethod<T> observerMethod) {
        if (this.configurator != null) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessObserverMethod.class.getSimpleName(), this.getReceiver());
        }
        Preconditions.checkArgumentNotNull(observerMethod, "observerMethod");
        this.checkWithinObserverNotification();
        this.replaceObserverMethod(observerMethod);
        this.observerMethodSet = true;
    }

    public ObserverMethodConfigurator<T> configureObserverMethod() {
        if (this.observerMethodSet) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessObserverMethod.class.getSimpleName(), this.getReceiver());
        }
        this.checkWithinObserverNotification();
        if (this.configurator == null) {
            this.configurator = new ObserverMethodConfiguratorImpl<T>(this.observerMethod);
        }
        return this.configurator;
    }

    public void veto() {
        this.checkWithinObserverNotification();
        this.vetoed = true;
    }

    public boolean isDirty() {
        return this.observerMethod != this.initialObserverMethod;
    }

    @Override
    public void postNotify(Extension extension) {
        super.postNotify(extension);
        if (this.configurator != null) {
            this.replaceObserverMethod(new ObserverMethodBuilderImpl<T>(this.configurator).build());
            this.configurator = null;
        }
        this.observerMethodSet = false;
    }

    private void replaceObserverMethod(ObserverMethod<T> observerMethod) {
        Observers.validateObserverMethod(observerMethod, (BeanManager)this.getBeanManager(), this.initialObserverMethod);
        this.observerMethod = observerMethod;
    }
}

