/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.builder.BeanAttributesConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class BeanAttributesConfiguratorImpl<T>
implements BeanAttributesConfigurator<T> {
    private String name;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Class<? extends Annotation> scope;
    private final Set<Class<? extends Annotation>> stereotypes;
    private Set<Type> types = new HashSet<Type>();
    private boolean isAlternative;

    public BeanAttributesConfiguratorImpl() {
        this.types.add((Type)((Object)Object.class));
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
    }

    public BeanAttributesConfiguratorImpl(BeanAttributes<T> beanAttributes) {
        this();
        this.read(beanAttributes);
    }

    public <U extends T> BeanAttributesConfigurator<U> read(AnnotatedType<U> type) {
        throw new UnsupportedOperationException();
    }

    public <U extends T> BeanAttributesConfigurator<U> read(AnnotatedMember<U> member) {
        throw new UnsupportedOperationException();
    }

    public BeanAttributesConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        this.name(beanAttributes.getName());
        this.qualifiers(beanAttributes.getQualifiers());
        this.scope(beanAttributes.getScope());
        this.stereotypes(beanAttributes.getStereotypes());
        this.types(beanAttributes.getTypes());
        this.alternative(beanAttributes.isAlternative());
        return this;
    }

    public BeanAttributesConfigurator<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    public BeanAttributesConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        this.types.add(typeLiteral.getType());
        return null;
    }

    public BeanAttributesConfigurator<T> addTypes(Type ... types) {
        Collections.addAll(this.types, types);
        return this;
    }

    public BeanAttributesConfigurator<T> addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public BeanAttributesConfigurator<T> addTransitiveTypeClosure(Type type) {
        this.types.addAll(Beans.getLegalBeanTypes(new HierarchyDiscovery(type).getTypeClosure(), type, new Type[0]));
        return this;
    }

    public BeanAttributesConfigurator<T> types(Type ... types) {
        this.types.clear();
        return this.addTypes(types);
    }

    public BeanAttributesConfigurator<T> types(Set<Type> types) {
        this.types.clear();
        return this.addTypes(types);
    }

    public BeanAttributesConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifier(Annotation qualifier) {
        this.removeDefaultQualifierIfNeeded(qualifier);
        this.qualifiers.add(qualifier);
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public BeanAttributesConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public BeanAttributesConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        this.stereotypes.add(stereotype);
        return this;
    }

    public BeanAttributesConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.addAll(stereotypes);
        return this;
    }

    public BeanAttributesConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.clear();
        return this.addStereotypes(stereotypes);
    }

    public BeanAttributesConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    public BeanAttributesConfigurator<T> alternative(boolean alternative) {
        this.isAlternative = alternative;
        return this;
    }

    String getName() {
        return this.name;
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    Class<? extends Annotation> getScope() {
        return this.scope;
    }

    Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    Set<Type> getTypes() {
        return this.types;
    }

    boolean isAlternative() {
        return this.isAlternative;
    }

    private void removeDefaultQualifierIfNeeded(Annotation qualifier) {
        if (!qualifier.annotationType().equals(Named.class)) {
            this.qualifiers.remove(Default.Literal.INSTANCE);
        }
    }
}

