/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.builder.InjectionPointConfigurator;
import org.jboss.weld.bootstrap.events.builder.Configurators;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionPointConfiguratorImpl
implements InjectionPointConfigurator {
    private Type requiredType;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Bean<?> bean;
    private boolean isDelegate;
    private boolean isTransient;
    private Member member;
    private Annotated annotated;

    public InjectionPointConfiguratorImpl() {
    }

    public InjectionPointConfiguratorImpl(InjectionPoint injectionPoint) {
        this();
        this.read(injectionPoint);
    }

    public InjectionPointConfigurator read(Field field) {
        this.member(field);
        this.transientField(Reflections.isTransient(field));
        this.delegate(field.isAnnotationPresent(Delegate.class));
        this.qualifiers(Configurators.getQualifiers(field));
        this.type(field.getType());
        return this;
    }

    public InjectionPointConfigurator read(Parameter param) {
        Executable executable = param.getDeclaringExecutable();
        this.member(executable);
        this.transientField(Reflections.isTransient(executable));
        this.delegate(executable.isAnnotationPresent(Delegate.class));
        this.qualifiers(Configurators.getQualifiers(executable));
        this.type(executable instanceof Method ? ((Method)executable).getReturnType() : param.getType());
        return this;
    }

    public InjectionPointConfigurator read(AnnotatedField<?> field) {
        this.annotated((Annotated)field);
        this.member(field.getJavaMember());
        this.transientField(Reflections.isTransient(field.getJavaMember()));
        this.delegate(field.isAnnotationPresent(Delegate.class));
        this.qualifiers(Configurators.getQualifiers(field));
        this.type(field.getBaseType());
        return this;
    }

    public InjectionPointConfigurator read(AnnotatedParameter<?> param) {
        this.annotated((Annotated)param);
        this.member(param.getDeclaringCallable().getJavaMember());
        this.transientField(false);
        this.delegate(param.isAnnotationPresent(Delegate.class));
        this.qualifiers(Configurators.getQualifiers(param));
        this.type(param.getBaseType());
        return this;
    }

    public InjectionPointConfigurator read(InjectionPoint injectionPoint) {
        this.bean(injectionPoint.getBean());
        this.type(injectionPoint.getType());
        this.qualifiers(injectionPoint.getQualifiers());
        this.delegate(injectionPoint.isDelegate());
        this.transientField(injectionPoint.isTransient());
        this.member(injectionPoint.getMember());
        this.annotated(injectionPoint.getAnnotated());
        return this;
    }

    public InjectionPointConfigurator type(Type type) {
        this.requiredType = type;
        return this;
    }

    public InjectionPointConfigurator addQualifier(Annotation qualifier) {
        this.qualifiers.remove(Default.Literal.INSTANCE);
        this.qualifiers.add(qualifier);
        return this;
    }

    public InjectionPointConfigurator addQualifiers(Annotation ... qualifiers) {
        this.qualifiers.remove(Default.Literal.INSTANCE);
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    public InjectionPointConfigurator addQualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.remove(Default.Literal.INSTANCE);
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public InjectionPointConfigurator qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public InjectionPointConfigurator qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    public InjectionPointConfigurator bean(Bean<?> bean) {
        this.bean = bean;
        return this;
    }

    public InjectionPointConfigurator delegate(boolean delegate) {
        this.isDelegate = delegate;
        return this;
    }

    public InjectionPointConfigurator transientField(boolean trans) {
        this.isTransient = trans;
        return this;
    }

    public InjectionPointConfigurator member(Member member) {
        this.member = member;
        return this;
    }

    public InjectionPointConfigurator annotated(Annotated annotated) {
        this.annotated = annotated;
        return this;
    }

    Type getRequiredType() {
        return this.requiredType;
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    Bean<?> getBean() {
        return this.bean;
    }

    boolean isDelegate() {
        return this.isDelegate;
    }

    boolean isTransient() {
        return this.isTransient;
    }

    Member getMember() {
        return this.member;
    }

    Annotated getAnnotated() {
        return this.annotated;
    }
}

