/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.builder.ObserverMethodConfigurator;
import org.jboss.weld.bootstrap.events.builder.ObserverMethodConfiguratorImpl;
import org.jboss.weld.event.SyntheticObserverMethod;
import org.jboss.weld.util.collections.ImmutableSet;

public class ObserverMethodBuilderImpl<T> {
    private final ObserverMethodConfiguratorImpl<T> configurator;

    public ObserverMethodBuilderImpl(ObserverMethodConfiguratorImpl<T> configurator) {
        this.configurator = configurator;
    }

    public ObserverMethodConfigurator<T> configure() {
        return this.configurator;
    }

    public ObserverMethod<T> build() {
        return new ImmutableObserverMethod<T>(this.configurator);
    }

    public static final class NotificationCallback<T> {
        private final Consumer<T> notifySimple;
        private final BiConsumer<T, EventMetadata> notifyMetadata;

        static <T> NotificationCallback<T> from(ObserverMethodConfiguratorImpl<T> configurator) {
            return configurator.getNotifySimple() != null ? new NotificationCallback<T>(configurator.getNotifySimple(), null) : new NotificationCallback<T>(null, configurator.getNotifyMetadata());
        }

        private NotificationCallback(Consumer<T> notifySimple, BiConsumer<T, EventMetadata> notifyMetadata) {
            this.notifySimple = notifySimple;
            this.notifyMetadata = notifyMetadata;
        }

        void notify(T event, EventMetadata metadata) {
            if (this.notifySimple != null) {
                this.notifySimple.accept(event);
            } else {
                this.notifyMetadata.accept(event, metadata);
            }
        }

        boolean isMetadataRequired() {
            return this.notifyMetadata != null;
        }
    }

    static class ImmutableObserverMethod<T>
    implements SyntheticObserverMethod<T> {
        private final Class<?> beanClass;
        private final Type observedType;
        private final Set<Annotation> observedQualifiers;
        private final Reception reception;
        private final TransactionPhase txPhase;
        private final int priority;
        private final boolean isAsync;
        private final NotificationCallback<T> notificationCallback;

        ImmutableObserverMethod(ObserverMethodConfiguratorImpl<T> configurator) {
            this.beanClass = configurator.getBeanClass();
            this.observedType = configurator.getObservedType();
            this.observedQualifiers = ImmutableSet.copyOf(configurator.getObservedQualifiers());
            this.reception = configurator.getReception();
            this.txPhase = configurator.getTxPhase();
            this.priority = configurator.getPriority();
            this.isAsync = configurator.isAsync();
            this.notificationCallback = NotificationCallback.from(configurator);
        }

        public int getPriority() {
            return this.priority;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Type getObservedType() {
            return this.observedType;
        }

        public Set<Annotation> getObservedQualifiers() {
            return this.observedQualifiers;
        }

        public Reception getReception() {
            return this.reception;
        }

        public TransactionPhase getTransactionPhase() {
            return this.txPhase;
        }

        public void notify(T event) {
            this.notificationCallback.notify(event, null);
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        @Override
        public void notify(T event, EventMetadata eventMetadata) {
            this.notificationCallback.notify(event, eventMetadata);
        }

        @Override
        public boolean isEventMetadataRequired() {
            return this.notificationCallback.isMetadataRequired();
        }
    }
}

