/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.builder.ObserverMethodConfigurator;
import org.jboss.weld.bootstrap.events.builder.Configurators;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.experimental.Priority;
import org.jboss.weld.util.reflection.Formats;

public class ObserverMethodConfiguratorImpl<T>
implements ObserverMethodConfigurator<T> {
    private static final int DEFAULT_PRIORITY = 2500;
    private Class<?> beanClass;
    private Type observedType;
    private final Set<Annotation> observedQualifiers;
    private Reception reception = Reception.ALWAYS;
    private TransactionPhase txPhase = TransactionPhase.IN_PROGRESS;
    private int priority = 2500;
    private boolean isAsync;
    private Consumer<T> notifySimple;
    private BiConsumer<T, EventMetadata> notifyMetadata;

    public ObserverMethodConfiguratorImpl() {
        this.observedQualifiers = new HashSet<Annotation>();
    }

    public ObserverMethodConfiguratorImpl(ObserverMethod<T> observerMethod) {
        this();
        this.read(observerMethod);
    }

    public ObserverMethodConfigurator<T> read(Method method) {
        Set<Parameter> eventParameters = Configurators.getAnnotatedParameters(method, Observes.class, ObservesAsync.class);
        this.checkEventParams(eventParameters, method);
        Parameter eventParameter = eventParameters.iterator().next();
        Observes observesAnnotation = eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
        } else {
            this.reception(eventParameter.getAnnotation(ObservesAsync.class).notifyObserver());
        }
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringExecutable().getDeclaringClass());
        this.observedType(eventParameter.getType());
        this.qualifiers(Configurators.getQualifiers(eventParameter));
        return this;
    }

    public ObserverMethodConfigurator<T> read(AnnotatedMethod<?> method) {
        Set eventParameters = method.getParameters().stream().filter(p -> p.isAnnotationPresent(Observes.class) || p.isAnnotationPresent(ObservesAsync.class)).collect(Collectors.toSet());
        this.checkEventParams(eventParameters, method.getJavaMember());
        AnnotatedParameter eventParameter = (AnnotatedParameter)eventParameters.iterator().next();
        Observes observesAnnotation = (Observes)eventParameter.getAnnotation(Observes.class);
        if (observesAnnotation != null) {
            this.reception(observesAnnotation.notifyObserver());
            this.transactionPhase(observesAnnotation.during());
        } else {
            this.reception(((ObservesAsync)eventParameter.getAnnotation(ObservesAsync.class)).notifyObserver());
        }
        Priority priority = (Priority)method.getAnnotation(Priority.class);
        if (priority != null) {
            this.priority(priority.value());
        }
        this.beanClass(eventParameter.getDeclaringCallable().getDeclaringType().getJavaClass());
        this.observedType(eventParameter.getBaseType());
        this.qualifiers(Configurators.getQualifiers((Annotated)eventParameter));
        return this;
    }

    public ObserverMethodConfigurator<T> read(ObserverMethod<T> observerMethod) {
        this.beanClass(observerMethod.getBeanClass());
        this.observedType(observerMethod.getObservedType());
        this.qualifiers(observerMethod.getObservedQualifiers());
        this.reception(observerMethod.getReception());
        this.transactionPhase(observerMethod.getTransactionPhase());
        this.priority(observerMethod.getPriority());
        this.async(observerMethod.isAsync());
        this.notifyWith((T e) -> observerMethod.notify(e));
        return this;
    }

    public ObserverMethodConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public ObserverMethodConfigurator<T> observedType(Type type) {
        this.observedType = type;
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifier(Annotation qualifier) {
        this.observedQualifiers.add(qualifier);
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        Collections.addAll(this.observedQualifiers, qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        this.observedQualifiers.addAll(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.observedQualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public ObserverMethodConfigurator<T> reception(Reception reception) {
        this.reception = reception;
        return this;
    }

    public ObserverMethodConfigurator<T> transactionPhase(TransactionPhase transactionPhase) {
        this.txPhase = transactionPhase;
        return this;
    }

    public ObserverMethodConfigurator<T> priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ObserverMethodConfigurator<T> notifyWith(Consumer<T> callback) {
        this.notifySimple = callback;
        this.notifyMetadata = null;
        return this;
    }

    public ObserverMethodConfigurator<T> notifyWith(BiConsumer<T, EventMetadata> callback) {
        this.notifySimple = null;
        this.notifyMetadata = callback;
        return this;
    }

    public ObserverMethodConfigurator<T> async(boolean async) {
        this.isAsync = async;
        return this;
    }

    Class<?> getBeanClass() {
        return this.beanClass;
    }

    Type getObservedType() {
        return this.observedType;
    }

    Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    Reception getReception() {
        return this.reception;
    }

    TransactionPhase getTxPhase() {
        return this.txPhase;
    }

    int getPriority() {
        return this.priority;
    }

    boolean isAsync() {
        return this.isAsync;
    }

    Consumer<T> getNotifySimple() {
        return this.notifySimple;
    }

    BiConsumer<T, EventMetadata> getNotifyMetadata() {
        return this.notifyMetadata;
    }

    private <P> void checkEventParams(Set<P> eventParams, Method method) {
        if (eventParams.size() != 1) {
            throw new IllegalArgumentException("None or multiple event parameters declared on: " + method + "\n\tat " + Formats.formatAsStackTraceElement(method) + "\n StackTrace:");
        }
    }
}

