/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.InjectionTargets;

public class InjectionTargetFactoryImpl<T>
implements WeldInjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> type;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        this.type = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = (InjectionTargetService)manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = (InjectionServices)manager.getServices().get(InjectionServices.class);
    }

    public WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        return this.createInjectionTarget(bean, false);
    }

    public WeldInjectionTarget<T> createInterceptorInjectionTarget() {
        return this.createInjectionTarget(null, true);
    }

    private WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean, boolean interceptor) {
        try {
            return this.validate((InjectionTarget)this.createInjectionTarget(this.type, bean, interceptor));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        BasicInjectionTarget<T> injectionTarget = this.chooseInjectionTarget(type, bean, interceptor);
        this.initialize(injectionTarget);
        this.postProcess((InjectionTarget<T>)injectionTarget);
        return injectionTarget;
    }

    private BasicInjectionTarget<T> chooseInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        if (bean instanceof Decorator || type.isAnnotationPresent(javax.decorator.Decorator.class)) {
            return new DecoratorInjectionTarget<T>(type, bean, this.manager);
        }
        NonProducibleInjectionTarget<T> nonProducible = InjectionTargets.createNonProducibleInjectionTarget(type, bean, this.manager);
        if (nonProducible != null) {
            return nonProducible;
        }
        if (bean instanceof SessionBean) {
            return ((EjbSupport)this.manager.getServices().get(EjbSupport.class)).createSessionBeanInjectionTarget(type, (SessionBean)bean, this.manager);
        }
        if (bean instanceof Interceptor || type.isAnnotationPresent(javax.interceptor.Interceptor.class)) {
            return BeanInjectionTarget.forCdiInterceptor(type, bean, this.manager);
        }
        if (interceptor) {
            return BasicInjectionTarget.createNonCdiInterceptor(type, this.manager);
        }
        return BeanInjectionTarget.createDefault(type, bean, this.manager);
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget(EjbDescriptor<T> descriptor) {
        return this.prepareInjectionTarget(((EjbSupport)this.manager.getServices().get(EjbSupport.class)).createMessageDrivenInjectionTarget(this.type, descriptor, this.manager));
    }

    private BasicInjectionTarget<T> initialize(BasicInjectionTarget<T> injectionTarget) {
        this.injectionTargetService.addInjectionTargetToBeInitialized(this.type, injectionTarget);
        return injectionTarget;
    }

    private <I extends InjectionTarget<T>> I validate(I injectionTarget) {
        this.injectionTargetService.validateProducer((Producer<?>)injectionTarget);
        return injectionTarget;
    }

    private void postProcess(InjectionTarget<T> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, this.type.slim());
        }
    }

    private BasicInjectionTarget<T> prepareInjectionTarget(BasicInjectionTarget<T> injectionTarget) {
        try {
            this.postProcess((InjectionTarget<T>)this.initialize(this.validate((InjectionTarget)injectionTarget)));
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public WeldInjectionTarget<T> createNonProducibleInjectionTarget() {
        return this.prepareInjectionTarget(NonProducibleInjectionTarget.create(this.type, null, this.manager));
    }
}

