/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.reflect.Member;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

abstract class AbstractResourceInjection<T>
implements ResourceInjection<T> {
    private final ResourceReferenceFactory<T> factory;

    AbstractResourceInjection(ResourceReferenceFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public T getResourceReference(CreationalContext<?> ctx) {
        ResourceReference reference = null;
        if (this.factory != null) {
            reference = this.factory.createResource();
        }
        if (reference != null) {
            if (ctx instanceof WeldCreationalContext) {
                ((WeldCreationalContext)Reflections.cast(ctx)).addDependentResourceReference(reference);
            }
            return (T)reference.getInstance();
        }
        UtilLogger.LOG.unableToInjectResource(this.getMember(), Formats.formatAsStackTraceElement(this.getMember()));
        return null;
    }

    @Override
    public void injectResourceReference(Object declaringInstance, CreationalContext<?> ctx) {
        this.injectMember(declaringInstance, this.getResourceReference(ctx));
    }

    protected abstract void injectMember(Object var1, Object var2);

    abstract Member getMember();
}

