/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInjector;
import org.jboss.weld.injection.producer.DefaultLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.ResourceInjector;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetBuilder;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.InjectionTargets;

public class WeldInjectionTargetBuilderImpl<T>
implements WeldInjectionTargetBuilder<T>,
PrivilegedAction<BasicInjectionTarget<T>> {
    private final InjectionTargetService injectionTargetService;
    private boolean resourceInjectionEnabled = true;
    private boolean targetClassLifecycleCallbacksEnabled = true;
    private boolean interceptorsEnabled = true;
    private boolean decorationEnabled = true;
    private Bean<T> bean;
    private final EnhancedAnnotatedType<T> type;
    private final BeanManagerImpl manager;

    public WeldInjectionTargetBuilderImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        this.type = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = (InjectionTargetService)manager.getServices().get(InjectionTargetService.class);
    }

    public WeldInjectionTargetBuilder<T> setResourceInjectionEnabled(boolean value) {
        this.resourceInjectionEnabled = value;
        return this;
    }

    public WeldInjectionTargetBuilder<T> setTargetClassLifecycleCallbacksEnabled(boolean value) {
        this.targetClassLifecycleCallbacksEnabled = value;
        return this;
    }

    public WeldInjectionTargetBuilder<T> setInterceptionEnabled(boolean value) {
        this.interceptorsEnabled = value;
        return this;
    }

    public WeldInjectionTargetBuilder<T> setDecorationEnabled(boolean value) {
        this.decorationEnabled = value;
        return this;
    }

    public WeldInjectionTargetBuilder<T> setBean(Bean<T> bean) {
        this.bean = bean;
        return this;
    }

    public WeldInjectionTarget<T> build() {
        if (System.getSecurityManager() != null) {
            return (WeldInjectionTarget)AccessController.doPrivileged(this);
        }
        return this.run();
    }

    @Override
    public BasicInjectionTarget<T> run() {
        BasicInjectionTarget<T> injectionTarget = this.buildInternal();
        this.injectionTargetService.addInjectionTargetToBeInitialized(this.type, injectionTarget);
        this.injectionTargetService.validateProducer(injectionTarget);
        return injectionTarget;
    }

    private BasicInjectionTarget<T> buildInternal() {
        LifecycleCallbackInvoker<T> invoker;
        Injector<T> injector = this.buildInjector();
        NonProducibleInjectionTarget<T> nonProducible = InjectionTargets.createNonProducibleInjectionTarget(this.type, this.bean, injector, invoker = this.buildInvoker(), this.manager);
        if (nonProducible != null) {
            return nonProducible;
        }
        if (!this.interceptorsEnabled && !this.decorationEnabled) {
            return BasicInjectionTarget.create(this.type, this.bean, this.manager, injector, invoker);
        }
        if (this.interceptorsEnabled && this.decorationEnabled) {
            return new BeanInjectionTarget<T>(this.type, this.bean, this.manager, injector, invoker);
        }
        throw new IllegalStateException("Unsupported combination: [interceptorsEnabled=" + this.interceptorsEnabled + ", decorationEnabled=" + this.decorationEnabled + "]");
    }

    private Injector<T> buildInjector() {
        if (this.resourceInjectionEnabled) {
            return ResourceInjector.of(this.type, this.bean, this.manager);
        }
        return DefaultInjector.of(this.type, this.bean, this.manager);
    }

    private LifecycleCallbackInvoker<T> buildInvoker() {
        if (this.targetClassLifecycleCallbacksEnabled) {
            return DefaultLifecycleCallbackInvoker.of(this.type);
        }
        return NoopLifecycleCallbackInvoker.getInstance();
    }

    public String toString() {
        return "WeldInjectionTargetBuilderImpl for " + this.type;
    }
}

