/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.test.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.test.util.el.EL;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.Reflections;

public class Utils {
    public static final int MASK = 255;

    private Utils() {
    }

    @SafeVarargs
    public static boolean annotationSetMatches(Set<? extends Annotation> annotations, Class<? extends Annotation> ... annotationTypes) {
        ArrayList<Class<? extends Annotation>> annotationTypeList = new ArrayList<Class<? extends Annotation>>();
        annotationTypeList.addAll(Arrays.asList(annotationTypes));
        for (Annotation annotation : annotations) {
            if (annotationTypeList.contains(annotation.annotationType())) {
                annotationTypeList.remove(annotation.annotationType());
                continue;
            }
            return false;
        }
        return annotationTypeList.size() == 0;
    }

    public static boolean typeSetMatches(Set<Type> types, Type ... requiredTypes) {
        List<Type> typeList = Arrays.asList(requiredTypes);
        return requiredTypes.length == types.size() && types.containsAll(typeList);
    }

    public static Iterable<URL> getResources(Class<?> clazz, String name) {
        name = name.startsWith("/") ? name.substring(1) : clazz.getPackage().getName().replace(".", "/") + "/" + name;
        try {
            return new EnumerationList(clazz.getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading resource from classloader" + name, e);
        }
    }

    public static byte[] serialize(Object instance) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(instance);
        return bytes.toByteArray();
    }

    public static <T> T deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (TCCLObjectInputStream in = new TCCLObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = Reflections.cast((Object)in.readObject());
            return (T)object;
        }
    }

    public static <T> T deserialize(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        try (TCCLObjectInputStream in = new TCCLObjectInputStream(new ByteArrayInputStream(bytes), cl);){
            Object object = Reflections.cast((Object)in.readObject());
            return (T)object;
        }
    }

    public static boolean isExceptionInHierarchy(Throwable exception, Class<? extends Throwable> expectedException) {
        while (exception != null) {
            if (exception.getClass().equals(expectedException)) {
                return true;
            }
            exception = exception.getCause();
        }
        return false;
    }

    public static <T> Bean<T> getBean(BeanManager beanManager, Type beanType, Annotation ... bindings) {
        Set beans = beanManager.getBeans(beanType, bindings);
        Bean bean = beanManager.resolve(beans);
        if (bean == null) {
            throw BeanManagerLogger.LOG.unresolvableType((Object)beanType, (Object)Arrays.toString(bindings));
        }
        Bean typedBean = bean;
        return typedBean;
    }

    public static <T> Set<Bean<T>> getBeans(BeanManager beanManager, Class<T> type, Annotation ... bindings) {
        return beanManager.getBeans(type, bindings);
    }

    public static <T> Set<Bean<T>> getBeans(BeanManager beanManager, TypeLiteral<T> type, Annotation ... bindings) {
        return beanManager.getBeans(type.getType(), bindings);
    }

    public static <T> T getReference(BeanManager beanManager, Class<T> beanType, Annotation ... bindings) {
        Bean<T> bean = Utils.getBean(beanManager, beanType, bindings);
        return (T)beanManager.getReference(bean, beanType, beanManager.createCreationalContext(bean));
    }

    public static <T> T getReference(BeanManager beanManager, Bean<T> bean) {
        return Utils.getReference(beanManager, bean, Object.class);
    }

    public static <T> T getReference(BeanManager beanManager, Bean<T> bean, Type beanType) {
        return (T)beanManager.getReference(bean, beanType, beanManager.createCreationalContext(bean));
    }

    public static <T> T evaluateValueExpression(BeanManagerImpl beanManager, String expression, Class<T> expectedType) {
        ELContext elContext = EL.createELContext(beanManager.getCurrent());
        return (T)EL.EXPRESSION_FACTORY.createValueExpression(elContext, expression, expectedType).getValue(elContext);
    }

    public static boolean isProxy(Object proxy) {
        return proxy instanceof ProxyObject;
    }

    public static <T extends Context> T getActiveContext(WeldManager beanManager, Class<T> type) {
        for (Context context : beanManager.instance().select(type, new Annotation[0])) {
            if (!context.isActive()) continue;
            return (T)context;
        }
        throw new ContextNotActiveException();
    }

    public static String getDeploymentNameAsHash(Class<?> testClass, ARCHIVE_TYPE archiveType) {
        String hexString = Utils.getHashOfTestClass(testClass.getName());
        switch (archiveType) {
            case JAR: {
                return hexString.toString() + ".jar";
            }
            case WAR: {
                return hexString.toString() + ".war";
            }
            case EAR: {
                return hexString.toString() + ".ear";
            }
        }
        return null;
    }

    public static String getDeploymentNameAsHash(Class<?> testClass) {
        return Utils.getDeploymentNameAsHash(testClass, ARCHIVE_TYPE.JAR);
    }

    public static String getHashOfTestClass(String testClassName) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(testClassName.getBytes());
        byte[] digest = messageDigest.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & digest[i]));
        }
        return hexString.toString();
    }

    public static enum ARCHIVE_TYPE {
        JAR,
        WAR,
        EAR;

    }

    private static class TCCLObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        private final ClassLoader optionalClassLoader;

        public TCCLObjectInputStream(InputStream in) throws IOException {
            this(in, null);
        }

        public TCCLObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.optionalClassLoader = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                String name = desc.getName();
                return Class.forName(name, false, this.tccl);
            }
            catch (ClassNotFoundException e) {
                try {
                    return super.resolveClass(desc);
                }
                catch (ClassNotFoundException e1) {
                    try {
                        return BeanManagerImpl.class.getClassLoader().loadClass(desc.getName());
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (this.optionalClassLoader != null) {
                            return this.optionalClassLoader.loadClass(desc.getName());
                        }
                        throw cnfe;
                    }
                }
            }
        }
    }
}

