/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.test.util.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.jboss.weld.test.util.annotated.TestAnnotationStore;
import org.jboss.weld.test.util.annotated.TestTypeClosureBuilder;

abstract class AbstractTestAnnotatedElement
implements Annotated {
    private final Class<?> type;
    private final Set<Type> typeClosure;
    private final TestAnnotationStore annotations;

    protected AbstractTestAnnotatedElement(Class<?> type, TestAnnotationStore annotations) {
        this.typeClosure = new TestTypeClosureBuilder().add(type).getTypes();
        this.annotations = annotations == null ? new TestAnnotationStore() : annotations;
        this.type = type;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.annotations.getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.isAnnotationPresent(annotationType);
    }

    public Set<Type> getTypeClosure() {
        return Collections.unmodifiableSet(this.typeClosure);
    }

    public Type getBaseType() {
        return this.type;
    }
}

