/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.test.util.annotated;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.test.util.annotated.AbstractTestAnnotatedElement;
import org.jboss.weld.test.util.annotated.TestAnnotatedConstructor;
import org.jboss.weld.test.util.annotated.TestAnnotatedField;
import org.jboss.weld.test.util.annotated.TestAnnotatedMethod;
import org.jboss.weld.test.util.annotated.TestAnnotationStore;

class TestAnnotatedType<X>
extends AbstractTestAnnotatedElement
implements AnnotatedType<X> {
    private final Set<AnnotatedConstructor<X>> constructors;
    private final Set<AnnotatedField<? super X>> fields;
    private final Set<AnnotatedMethod<? super X>> methods;
    private final Class<X> javaClass;

    TestAnnotatedType(Class<X> clazz, TestAnnotationStore typeAnnotations, Map<Field, TestAnnotationStore> fieldAnnotations, Map<Method, TestAnnotationStore> methodAnnotations, Map<Method, Map<Integer, TestAnnotationStore>> methodParameterAnnotations, Map<Constructor<X>, TestAnnotationStore> constructorAnnotations, Map<Constructor<X>, Map<Integer, TestAnnotationStore>> constructorParameterAnnotations) {
        super(clazz, typeAnnotations);
        this.javaClass = clazz;
        this.constructors = new HashSet<AnnotatedConstructor<X>>();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            TestAnnotatedConstructor nc = new TestAnnotatedConstructor(this, constructor, constructorAnnotations.get(constructor), constructorParameterAnnotations.get(constructor));
            this.constructors.add(nc);
        }
        this.methods = new HashSet<AnnotatedMethod<? super X>>();
        for (Executable executable : clazz.getDeclaredMethods()) {
            TestAnnotatedMethod met = new TestAnnotatedMethod(this, (Method)executable, methodAnnotations.get(executable), methodParameterAnnotations.get(executable));
            this.methods.add(met);
        }
        this.fields = new HashSet<AnnotatedField<? super X>>();
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            TestAnnotatedField b = new TestAnnotatedField(this, (Field)accessibleObject, fieldAnnotations.get(accessibleObject));
            this.fields.add(b);
        }
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }
}

