/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.test.util.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.test.util.annotated.TestAnnotatedType;
import org.jboss.weld.test.util.annotated.TestAnnotationBuilder;
import org.jboss.weld.test.util.annotated.TestAnnotationStore;

public class TestAnnotatedTypeBuilder<X> {
    private Map<Field, TestAnnotationBuilder> fields = new HashMap<Field, TestAnnotationBuilder>();
    private Map<Method, TestAnnotationBuilder> methods = new HashMap<Method, TestAnnotationBuilder>();
    private Map<Method, Map<Integer, TestAnnotationBuilder>> methodParameters = new HashMap<Method, Map<Integer, TestAnnotationBuilder>>();
    private Map<Constructor<X>, TestAnnotationBuilder> constructors = new HashMap<Constructor<X>, TestAnnotationBuilder>();
    private Map<Constructor<X>, Map<Integer, TestAnnotationBuilder>> constructorParameters = new HashMap<Constructor<X>, Map<Integer, TestAnnotationBuilder>>();
    private TestAnnotationBuilder typeAnnotations = new TestAnnotationBuilder();
    private Class<X> underlying;

    public TestAnnotatedTypeBuilder(Class<X> underlying) {
        this.underlying = underlying;
    }

    public TestAnnotatedTypeBuilder<X> addToClass(Annotation a) {
        this.typeAnnotations.add(a);
        return this;
    }

    public TestAnnotatedTypeBuilder<X> addToField(Field field, Annotation a) {
        TestAnnotationBuilder annotations = this.fields.get(field);
        if (annotations == null) {
            annotations = new TestAnnotationBuilder();
            this.fields.put(field, annotations);
        }
        annotations.add(a);
        return this;
    }

    public TestAnnotatedTypeBuilder<X> addToMethod(Method method, Annotation a) {
        TestAnnotationBuilder annotations = this.methods.get(method);
        if (annotations == null) {
            annotations = new TestAnnotationBuilder();
            this.methods.put(method, annotations);
        }
        annotations.add(a);
        return this;
    }

    public TestAnnotatedTypeBuilder<X> addToMethodParameter(Method method, int parameter, Annotation a) {
        TestAnnotationBuilder annotations;
        Map<Integer, TestAnnotationBuilder> anmap = this.methodParameters.get(method);
        if (anmap == null) {
            anmap = new HashMap<Integer, TestAnnotationBuilder>();
            this.methodParameters.put(method, anmap);
        }
        if ((annotations = anmap.get(parameter)) == null) {
            annotations = new TestAnnotationBuilder();
            anmap.put(parameter, annotations);
        }
        annotations.add(a);
        return this;
    }

    public TestAnnotatedTypeBuilder<X> addToConstructor(Constructor<X> constructor, Annotation a) {
        TestAnnotationBuilder annotations = this.constructors.get(constructor);
        if (annotations == null) {
            annotations = new TestAnnotationBuilder();
            this.constructors.put(constructor, annotations);
        }
        annotations.add(a);
        return this;
    }

    public TestAnnotatedTypeBuilder<X> addToConstructorParameter(Constructor<X> constructor, int parameter, Annotation a) {
        TestAnnotationBuilder annotations;
        Map<Integer, TestAnnotationBuilder> anmap = this.constructorParameters.get(constructor);
        if (anmap == null) {
            anmap = new HashMap<Integer, TestAnnotationBuilder>();
            this.constructorParameters.put(constructor, anmap);
        }
        if ((annotations = anmap.get(parameter)) == null) {
            annotations = new TestAnnotationBuilder();
            anmap.put(parameter, annotations);
        }
        annotations.add(a);
        return this;
    }

    public AnnotatedType<X> create() {
        HashMap parameterAnnotations;
        HashMap constructorParameterAnnotations = new HashMap();
        HashMap constructorAnnotations = new HashMap();
        HashMap<Method, Map<Integer, TestAnnotationStore>> methodParameterAnnotations = new HashMap<Method, Map<Integer, TestAnnotationStore>>();
        HashMap<Method, TestAnnotationStore> methodAnnotations = new HashMap<Method, TestAnnotationStore>();
        HashMap<Field, TestAnnotationStore> fieldAnnotations = new HashMap<Field, TestAnnotationStore>();
        for (Map.Entry<Field, TestAnnotationBuilder> entry : this.fields.entrySet()) {
            fieldAnnotations.put(entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, TestAnnotationBuilder> entry : this.methods.entrySet()) {
            methodAnnotations.put((Method)entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.methodParameters.entrySet()) {
            parameterAnnotations = new HashMap();
            methodParameterAnnotations.put((Method)entry.getKey(), parameterAnnotations);
            for (Map.Entry pe : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put(pe.getKey(), ((TestAnnotationBuilder)pe.getValue()).create());
            }
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructors.entrySet()) {
            constructorAnnotations.put(entry.getKey(), ((TestAnnotationBuilder)entry.getValue()).create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructorParameters.entrySet()) {
            parameterAnnotations = new HashMap();
            constructorParameterAnnotations.put(entry.getKey(), (Map<Integer, TestAnnotationStore>)parameterAnnotations);
            for (Map.Entry pe : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put(pe.getKey(), ((TestAnnotationBuilder)pe.getValue()).create());
            }
        }
        return new TestAnnotatedType<X>(this.underlying, this.typeAnnotations.create(), fieldAnnotations, methodAnnotations, methodParameterAnnotations, constructorAnnotations, constructorParameterAnnotations);
    }
}

