/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.tests.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import org.junit.Assert;

public class BeanUtilities {
    private static final String FOUND_ON = " found on ";
    private static final String NOT_FOUND_ON = " not found on ";

    private BeanUtilities() {
    }

    public static void verifyTypes(BeanAttributes<?> attributes, Type ... expectedTypes) {
        HashSet types = new HashSet(attributes.getTypes());
        for (Type type : expectedTypes) {
            if (types.remove(type)) continue;
            Assert.fail((String)("Expected type " + type + " not a bean type of " + attributes));
        }
        Assert.assertTrue((String)("The following unexpected types " + types + FOUND_ON + attributes), (boolean)types.isEmpty());
    }

    public static void verifyStereotypes(BeanAttributes<?> attributes, Class<?> ... expected) {
        HashSet stereotypes = new HashSet(attributes.getStereotypes());
        Assert.assertEquals((long)expected.length, (long)stereotypes.size());
        for (Class<?> stereotype : expected) {
            if (stereotypes.remove(stereotype)) continue;
            Assert.fail((String)("Expected stereotype " + stereotype + NOT_FOUND_ON + attributes));
        }
        Assert.assertTrue((String)("The following unexpected stereotypes " + stereotypes + FOUND_ON + attributes), (boolean)stereotypes.isEmpty());
    }

    public static void verifyQualifierTypes(BeanAttributes<?> attributes, Class<?> ... expectedTypes) {
        BeanUtilities.verifyQualifierTypes(attributes.getQualifiers(), expectedTypes);
    }

    public static void verifyQualifierTypes(Set<Annotation> annotations, Class<?> ... expectedTypes) {
        HashSet expectedQualifierTypes = new HashSet(Arrays.asList(expectedTypes));
        for (Annotation qualifier : annotations) {
            if (expectedQualifierTypes.remove(qualifier.annotationType())) continue;
            Assert.fail((String)("Unexpected qualifier type " + qualifier.annotationType()));
        }
        Assert.assertTrue((String)("Expected qualifier types " + expectedQualifierTypes + " not found"), (boolean)expectedQualifierTypes.isEmpty());
    }

    public static void verifyQualifiers(BeanAttributes<?> attributes, Annotation ... expectedAnnotations) {
        HashSet<Annotation> expectedQualifiers = new HashSet<Annotation>(Arrays.asList(expectedAnnotations));
        for (Annotation qualifier : attributes.getQualifiers()) {
            if (expectedQualifiers.remove(qualifier)) continue;
            Assert.fail((String)("Expected qualifier not present " + qualifier.annotationType()));
        }
        Assert.assertTrue((String)("Expected qualifiers" + expectedQualifiers + NOT_FOUND_ON + attributes), (boolean)expectedQualifiers.isEmpty());
    }
}

