/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.tests.util;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.jboss.weld.config.ConfigurationKey;

@Startup
@Singleton
public class SystemPropertiesLoader {
    public static final String PROPERTIES_FILE_NAME = "system.properties";

    @PostConstruct
    public void setProperties() {
        Properties props = this.load(PROPERTIES_FILE_NAME);
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    @PreDestroy
    public void unsetProperties() {
        Properties props = this.load(PROPERTIES_FILE_NAME);
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                if (ConfigurationKey.fromString((String)entry.getKey().toString()) != null) {
                    System.setProperty(entry.getKey().toString(), ConfigurationKey.fromString((String)entry.getKey().toString()).getDefaultValue().toString());
                    continue;
                }
                System.clearProperty(entry.getKey().toString());
            }
        }
    }

    private Properties load(String resource) {
        InputStream propsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (propsStream != null) {
            Properties props = new Properties();
            try {
                props.load(propsStream);
                return props;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load properties", e);
            }
        }
        return null;
    }
}

