/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.bean;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.extensions.bean.ContextualLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingContextualLifecycle<T>
implements ContextualLifecycle<T> {
    private final InjectionTarget<T> injectionTarget;

    public DelegatingContextualLifecycle(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    @Override
    public T create(Bean<T> bean, CreationalContext<T> creationalContext) {
        Object instance = this.injectionTarget.produce(creationalContext);
        this.injectionTarget.inject(instance, creationalContext);
        this.injectionTarget.postConstruct(instance);
        return (T)instance;
    }

    @Override
    public void destroy(Bean<T> bean, T instance, CreationalContext<T> creationalContext) {
        try {
            this.injectionTarget.preDestroy(instance);
            creationalContext.release();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

