/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.extensions.bean.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableInjectionPoint
implements InjectionPoint {
    private final Annotated annotated;
    private final Member member;
    private final Bean<?> declaringBean;
    private final Set<Annotation> qualifiers;
    private final Type type;
    private final boolean _transient;
    private final boolean delegate;

    public ImmutableInjectionPoint(AnnotatedField<?> field, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        this.type = field.getJavaMember().getGenericType();
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedField<?> field, BeanManager beanManager, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = Beans.getQualifiers(beanManager, (Iterable<Annotation>)field.getAnnotations());
        this.type = field.getJavaMember().getGenericType();
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, BeanManager beanManager, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = Beans.getQualifiers(beanManager, (Iterable<Annotation>)parameter.getAnnotations());
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public Member getMember() {
        return this.member;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public boolean isTransient() {
        return this._transient;
    }
}

