/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.bean.defaultbean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.weld.extensions.bean.Beans;
import org.jboss.weld.extensions.bean.defaultbean.DefaultBean;
import org.jboss.weld.extensions.bean.defaultbean.DefaultManagedBean;
import org.jboss.weld.extensions.bean.defaultbean.DefaultObserverMethod;
import org.jboss.weld.extensions.bean.defaultbean.DefaultProducerField;
import org.jboss.weld.extensions.bean.defaultbean.DefaultProducerMethod;
import org.jboss.weld.extensions.literal.DefaultLiteral;
import org.jboss.weld.extensions.reflection.Synthetic;
import org.jboss.weld.extensions.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.weld.extensions.util.collections.Multimaps;
import org.jboss.weld.extensions.util.collections.SetMultimap;
import org.jboss.weld.extensions.util.collections.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanExtension
implements Extension {
    private static final String QUALIFIER_NAMEPSACE = "org.jboss.weld.extensions.defaultbean";
    private static final String PRODUCER_QUALIFIER_NAMEPSACE = "org.jboss.weld.extensions.defaultbean.producer";
    private static final Logger log = LoggerFactory.getLogger(DefaultBeanExtension.class);
    private boolean beanDiscoveryOver = false;
    private final List<Bean<?>> processedBeans = new LinkedList();
    private final Map<Synthetic, DefaultBeanType> beanTypeInformation = new HashMap<Synthetic, DefaultBeanType>();
    private final Map<Synthetic, Bean<?>> defaultManagedBeans = new HashMap();
    private final Map<Synthetic, Bean<?>> defaultProducerMethods = new HashMap();
    private final Map<Synthetic, Bean<?>> defaultProducerFields = new HashMap();
    private final SetMultimap<Synthetic, ObserverMethodInfo<?>> defaultObserverMethodsByBean = Multimaps.newSetMultimap(new HashMap(), DefaultBeanExtension.createHashSetSupplier());
    private final Map<Method, ObserverMethodInfo<?>> defaultObserverMethods = new HashMap();
    private final Map<Synthetic, DefaultBeanQualifiers> producerToDeclaringDefaultBean = new HashMap<Synthetic, DefaultBeanQualifiers>();
    private final Map<Synthetic, DefaultProducerMethodInfo<?>> producerAnnotatedMethods = new HashMap();
    private final Map<Synthetic, AnnotatedField<?>> producerAnnotatedFields = new HashMap();
    private final Synthetic.Provider syntheticProvider = new Synthetic.Provider("org.jboss.weld.extensions.defaultbean");
    private final Synthetic.Provider producerSyntheticProvider = new Synthetic.Provider("org.jboss.weld.extensions.defaultbean.producer");
    private final Set<Throwable> deploymentProblems = new HashSet<Throwable>();

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        Type type;
        Synthetic syntheticQualifier;
        HashSet<Annotation> qualifiers;
        boolean defaultBean = false;
        AnnotatedType tp = event.getAnnotatedType();
        AnnotatedTypeBuilder builder = null;
        Synthetic declaringBeanSyntheticQualifier = null;
        HashSet<Object> declaringBeanQualifiers = null;
        if (event.getAnnotatedType().isAnnotationPresent(DefaultBean.class)) {
            HashSet<Annotation> qualifiers2 = new HashSet<Annotation>();
            defaultBean = true;
            builder = new AnnotatedTypeBuilder().readFromType(tp);
            for (Annotation a : tp.getAnnotations()) {
                if (!beanManager.isQualifier(a.annotationType())) continue;
                qualifiers2.add(a);
                builder.removeFromClass(a.annotationType());
            }
            if (qualifiers2.isEmpty()) {
                qualifiers2.add((Annotation)DefaultLiteral.INSTANCE);
            }
            declaringBeanQualifiers = new HashSet(qualifiers2);
            declaringBeanSyntheticQualifier = this.syntheticProvider.get();
            this.beanTypeInformation.put(declaringBeanSyntheticQualifier, new DefaultBeanType(qualifiers2, ((DefaultBean)tp.getAnnotation(DefaultBean.class)).value()));
            builder.addToClass(declaringBeanSyntheticQualifier);
            for (AnnotatedMethod m : tp.getMethods()) {
                AnnotatedParameter observerParameter = null;
                for (AnnotatedParameter p : m.getParameters()) {
                    if (!p.isAnnotationPresent(Observes.class)) continue;
                    observerParameter = p;
                    break;
                }
                if (observerParameter == null) continue;
                HashSet<Annotation> observerQualifiers = new HashSet<Annotation>();
                for (Annotation a : observerParameter.getAnnotations()) {
                    if (!beanManager.isQualifier(a.annotationType())) continue;
                    observerQualifiers.add(a);
                    builder.removeFromMethodParameter(m.getJavaMember(), observerParameter.getPosition(), a.annotationType());
                }
                if (qualifiers2.isEmpty()) {
                    qualifiers2.add((Annotation)DefaultLiteral.INSTANCE);
                }
                builder.addToMethodParameter(m.getJavaMember(), observerParameter.getPosition(), declaringBeanSyntheticQualifier);
                ObserverMethodInfo info = ObserverMethodInfo.of(observerQualifiers, declaringBeanQualifiers, m, declaringBeanSyntheticQualifier);
                this.defaultObserverMethodsByBean.put(declaringBeanSyntheticQualifier, info);
                this.defaultObserverMethods.put(m.getJavaMember(), info);
            }
        }
        for (AnnotatedMethod m : tp.getMethods()) {
            if (!m.isAnnotationPresent(Produces.class) || !defaultBean && !m.isAnnotationPresent(DefaultBean.class)) continue;
            if (declaringBeanQualifiers == null && (declaringBeanQualifiers = new HashSet<Annotation>(Beans.getQualifiers(beanManager, (Iterable<Annotation>)tp.getAnnotations()))).isEmpty()) {
                declaringBeanQualifiers.add(DefaultLiteral.INSTANCE);
            }
            if (builder == null) {
                builder = new AnnotatedTypeBuilder().readFromType(tp);
            }
            qualifiers = new HashSet<Annotation>();
            for (Annotation a : m.getAnnotations()) {
                if (!beanManager.isQualifier(a.annotationType())) continue;
                qualifiers.add(a);
                builder.removeFromMethod(m, a.annotationType());
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
            }
            syntheticQualifier = this.producerSyntheticProvider.get();
            type = null;
            type = m.isAnnotationPresent(DefaultBean.class) ? ((DefaultBean)m.getAnnotation(DefaultBean.class)).value() : m.getJavaMember().getGenericReturnType();
            this.beanTypeInformation.put(syntheticQualifier, new DefaultBeanType(qualifiers, type));
            builder.addToMethod(m, (Annotation)syntheticQualifier);
            this.producerToDeclaringDefaultBean.put(syntheticQualifier, new DefaultBeanQualifiers(declaringBeanSyntheticQualifier, declaringBeanQualifiers));
        }
        for (AnnotatedField f : tp.getFields()) {
            if (!f.isAnnotationPresent(Produces.class) || !defaultBean && !f.isAnnotationPresent(DefaultBean.class)) continue;
            if (declaringBeanQualifiers == null && (declaringBeanQualifiers = new HashSet<Annotation>(Beans.getQualifiers(beanManager, (Iterable<Annotation>)tp.getAnnotations()))).isEmpty()) {
                declaringBeanQualifiers.add(DefaultLiteral.INSTANCE);
            }
            for (Annotation i : tp.getAnnotations()) {
                if (!beanManager.isNormalScope(i.annotationType())) continue;
                this.deploymentProblems.add(new RuntimeException("Default producer fields are not supported on normal scoped beans. Field: " + f + " Declaring Bean: " + tp));
            }
            if (builder == null) {
                builder = new AnnotatedTypeBuilder().readFromType(tp);
            }
            qualifiers = new HashSet();
            for (Annotation a : f.getAnnotations()) {
                if (!beanManager.isQualifier(a.annotationType())) continue;
                qualifiers.add(a);
                builder.removeFromField(f, a.annotationType());
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
            }
            syntheticQualifier = this.producerSyntheticProvider.get();
            type = null;
            type = f.isAnnotationPresent(DefaultBean.class) ? ((DefaultBean)f.getAnnotation(DefaultBean.class)).value() : f.getJavaMember().getGenericType();
            this.beanTypeInformation.put(syntheticQualifier, new DefaultBeanType(qualifiers, type));
            builder.addToField(f, (Annotation)syntheticQualifier);
            this.producerToDeclaringDefaultBean.put(syntheticQualifier, new DefaultBeanQualifiers(declaringBeanSyntheticQualifier, declaringBeanQualifiers));
        }
        if (builder != null) {
            event.setAnnotatedType(builder.create());
        }
    }

    <X> void processBean(@Observes ProcessBean<X> event) {
        if (this.beanDiscoveryOver) {
            return;
        }
        Bean b = event.getBean();
        this.processedBeans.add(b);
        Synthetic qualifier = null;
        for (Annotation a : b.getQualifiers()) {
            Synthetic sa;
            if (!(a instanceof Synthetic) || !(sa = (Synthetic)a).namespace().equals(QUALIFIER_NAMEPSACE)) continue;
            qualifier = sa;
            break;
        }
        if (qualifier != null) {
            this.defaultManagedBeans.put(qualifier, b);
        }
    }

    <T, X> void processProducer(@Observes ProcessProducerMethod<T, X> event) {
        if (this.beanDiscoveryOver) {
            return;
        }
        Bean b = event.getBean();
        Synthetic qualifier = this.handleProducerBean(b);
        if (qualifier != null) {
            this.defaultProducerMethods.put(qualifier, event.getBean());
            AnnotatedMethod method = event.getAnnotatedProducerMethod();
            AnnotatedMethod disposerMethod = null;
            if (event.getAnnotatedDisposedParameter() != null) {
                disposerMethod = (AnnotatedMethod)event.getAnnotatedDisposedParameter().getDeclaringCallable();
            }
            this.producerAnnotatedMethods.put(qualifier, new DefaultProducerMethodInfo(method, disposerMethod));
        }
    }

    <T, X> void processProducer(@Observes ProcessProducerField<T, X> event) {
        if (this.beanDiscoveryOver) {
            return;
        }
        Bean b = event.getBean();
        Synthetic qualifier = this.handleProducerBean(b);
        if (qualifier != null) {
            this.defaultProducerFields.put(qualifier, event.getBean());
            this.producerAnnotatedFields.put(qualifier, event.getAnnotatedProducerField());
        }
    }

    <X> Synthetic handleProducerBean(Bean<X> b) {
        Synthetic qualifier = null;
        for (Annotation a : b.getQualifiers()) {
            Synthetic sa;
            if (!(a instanceof Synthetic) || !(sa = (Synthetic)a).namespace().equals(PRODUCER_QUALIFIER_NAMEPSACE)) continue;
            qualifier = sa;
            break;
        }
        return qualifier;
    }

    <T, X> void processObserverMethod(@Observes ProcessObserverMethod<T, X> event) {
        Synthetic qualifier = null;
        for (Annotation a : event.getObserverMethod().getObservedQualifiers()) {
            Synthetic sa;
            if (!(a instanceof Synthetic) || !(sa = (Synthetic)a).namespace().equals(QUALIFIER_NAMEPSACE)) continue;
            qualifier = sa;
            break;
        }
        if (qualifier != null) {
            ObserverMethodInfo<?> info = this.defaultObserverMethods.get(event.getAnnotatedMethod().getJavaMember());
            info.setDelegate(event.getObserverMethod());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        this.beanDiscoveryOver = true;
        HashMap duplicateDetectionMap = new HashMap();
        for (Map.Entry<Synthetic, DefaultBeanType> entry : this.beanTypeInformation.entrySet()) {
            Bean<?> bean = this.defaultManagedBeans.get(entry.getKey());
            if (bean == null) {
                bean = this.defaultProducerMethods.get(entry.getKey());
            }
            if (bean == null) {
                bean = this.defaultProducerFields.get(entry.getKey());
            }
            if (duplicateDetectionMap.containsKey(entry.getValue())) {
                Bean other = (Bean)duplicateDetectionMap.get(entry.getValue());
                this.deploymentProblems.add(new RuntimeException("Two default beans with the same type and qualifiers: Type: " + entry.getValue().getType() + " Qualifiers: " + entry.getValue().getQualifiers() + " Beans are " + other.toString() + " and " + bean.toString()));
            }
            duplicateDetectionMap.put(entry.getValue(), bean);
        }
        if (this.beanTypeInformation.size() > 0) {
            for (Bean bean : this.processedBeans) {
                Iterator<Map.Entry<Synthetic, DefaultBeanType>> it = this.beanTypeInformation.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Synthetic, DefaultBeanType> definition = it.next();
                    if (!definition.getValue().matches(bean)) continue;
                    Synthetic qual = definition.getKey();
                    Bean<?> bean2 = null;
                    bean2 = this.defaultManagedBeans.remove(qual);
                    if (bean2 == null) {
                        bean2 = this.defaultProducerMethods.remove(qual);
                    }
                    if (bean2 == null) {
                        bean2 = this.defaultProducerFields.remove(qual);
                    }
                    log.info("Preventing install of default bean " + bean2);
                    it.remove();
                }
            }
        }
        HashSet<Synthetic> allDefaultBeanQualifiers = new HashSet<Synthetic>(this.defaultManagedBeans.keySet());
        allDefaultBeanQualifiers.addAll(this.defaultProducerFields.keySet());
        allDefaultBeanQualifiers.addAll(this.defaultProducerMethods.keySet());
        for (Synthetic qual : allDefaultBeanQualifiers) {
            Set<Annotation> declaringBeanQualifiers;
            Synthetic declaringDefaultBean;
            DefaultBeanType beanInfo = this.beanTypeInformation.get(qual);
            HashSet<Type> types = new HashSet<Type>();
            types.add((Type)((Object)Object.class));
            types.add(beanInfo.getType());
            HashSet<Annotation> qualifiers = new HashSet<Annotation>(beanInfo.getQualifiers());
            if (this.defaultManagedBeans.containsKey(qual)) {
                DefaultManagedBean<?> db = DefaultManagedBean.of(this.defaultManagedBeans.get(qual), beanInfo.getType(), types, qualifiers, manager);
                log.info("Installing default managed bean " + db);
                event.addBean(db);
                Set<ObserverMethodInfo<?>> observers = this.defaultObserverMethodsByBean.get(qual);
                for (ObserverMethodInfo<?> i : observers) {
                    DefaultObserverMethod<?, ?> obs = DefaultObserverMethod.of(i.getDelegate(), i.getAnnotatedMethod(), qualifiers, i.getObserverParameterQualifier(), db, manager);
                    event.addObserverMethod(obs);
                }
                continue;
            }
            if (this.defaultProducerMethods.containsKey(qual)) {
                declaringDefaultBean = this.producerToDeclaringDefaultBean.get(qual).getSyntheticQualifier();
                declaringBeanQualifiers = declaringDefaultBean != null && !this.beanTypeInformation.containsKey(declaringDefaultBean) ? Collections.singleton(declaringDefaultBean) : this.producerToDeclaringDefaultBean.get(qual).getQualifiers();
                DefaultProducerMethodInfo<?> info = this.producerAnnotatedMethods.get(qual);
                DefaultProducerMethod<?, ?> db = this.createDefaultProducerMethod(this.defaultProducerMethods.get(qual), qual, beanInfo, types, qualifiers, declaringBeanQualifiers, info, manager);
                log.info("Installing default producer bean " + db);
                event.addBean(db);
                continue;
            }
            if (!this.defaultProducerFields.containsKey(qual)) continue;
            declaringDefaultBean = this.producerToDeclaringDefaultBean.get(qual).getSyntheticQualifier();
            declaringBeanQualifiers = declaringDefaultBean != null && !this.beanTypeInformation.containsKey(declaringDefaultBean) ? Collections.singleton(declaringDefaultBean) : this.producerToDeclaringDefaultBean.get(qual).getQualifiers();
            DefaultProducerField<?, ?> db = DefaultProducerField.of(this.defaultProducerFields.get(qual), beanInfo.getType(), types, qualifiers, declaringBeanQualifiers, this.producerAnnotatedFields.get(qual), manager);
            log.info("Installing default producer bean " + db);
            event.addBean(db);
        }
        for (Throwable e : this.deploymentProblems) {
            event.addDefinitionError(e);
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation event) {
        this.processedBeans.clear();
        this.beanTypeInformation.clear();
        this.producerToDeclaringDefaultBean.clear();
        this.producerSyntheticProvider.clear();
        this.producerAnnotatedFields.clear();
        this.producerAnnotatedMethods.clear();
    }

    private static <T> Supplier<Set<T>> createHashSetSupplier() {
        return new Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return new HashSet();
            }
        };
    }

    private <T, X> DefaultProducerMethod<T, X> createDefaultProducerMethod(Bean<T> originalBean, Annotation qualifier, DefaultBeanType beanInfo, Set<Type> types, Set<Annotation> qualifiers, Set<Annotation> declaringBeanQualifiers, DefaultProducerMethodInfo<X> info, BeanManager beanManager) {
        return DefaultProducerMethod.of(originalBean, beanInfo.getType(), types, qualifiers, declaringBeanQualifiers, info.getProducerMethod(), info.getDisposerMethod(), beanManager);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultBeanQualifiers {
        private Synthetic syntheticQualifier;
        private Set<Annotation> qualifiers;

        public DefaultBeanQualifiers(Synthetic syntheticQualifier, Set<Annotation> qualifiers) {
            this.syntheticQualifier = syntheticQualifier;
            this.qualifiers = qualifiers;
        }

        public Synthetic getSyntheticQualifier() {
            return this.syntheticQualifier;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultProducerMethodInfo<X> {
        private final AnnotatedMethod<X> producerMethod;
        private final AnnotatedMethod<X> disposerMethod;

        public DefaultProducerMethodInfo(AnnotatedMethod<X> producerMethod, AnnotatedMethod<X> disposerMethod) {
            this.producerMethod = producerMethod;
            this.disposerMethod = disposerMethod;
        }

        public AnnotatedMethod<X> getProducerMethod() {
            return this.producerMethod;
        }

        public AnnotatedMethod<X> getDisposerMethod() {
            return this.disposerMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObserverMethodInfo<T> {
        private final Set<Annotation> observerParameterQualifier;
        private final Set<Annotation> declaringBeanQualfiers;
        private final AnnotatedMethod<T> annotatedMethod;
        private final Synthetic defaultBeanSynthetic;
        private ObserverMethod<?> delegate;

        public static <T> ObserverMethodInfo<T> of(Set<Annotation> observerParameterQualifier, Set<Annotation> declaringBeanQualfiers, AnnotatedMethod<T> annotatedMethod, Synthetic defaultBeanSynthetic) {
            return new ObserverMethodInfo<T>(observerParameterQualifier, declaringBeanQualfiers, annotatedMethod, defaultBeanSynthetic);
        }

        public ObserverMethodInfo(Set<Annotation> observerParameterQualifier, Set<Annotation> declaringBeanQualfiers, AnnotatedMethod<T> annotatedMethod, Synthetic defaultBeanSynthetic) {
            this.observerParameterQualifier = observerParameterQualifier;
            this.declaringBeanQualfiers = declaringBeanQualfiers;
            this.annotatedMethod = annotatedMethod;
            this.defaultBeanSynthetic = defaultBeanSynthetic;
        }

        public Set<Annotation> getObserverParameterQualifier() {
            return this.observerParameterQualifier;
        }

        public AnnotatedMethod<T> getAnnotatedMethod() {
            return this.annotatedMethod;
        }

        public ObserverMethod<?> getDelegate() {
            return this.delegate;
        }

        public void setDelegate(ObserverMethod<?> delegate) {
            this.delegate = delegate;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringBeanQualfiers == null ? 0 : ((Object)this.declaringBeanQualfiers).hashCode());
            result = 31 * result + (this.observerParameterQualifier == null ? 0 : ((Object)this.observerParameterQualifier).hashCode());
            result = 31 * result + (this.defaultBeanSynthetic == null ? 0 : this.defaultBeanSynthetic.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObserverMethodInfo other = (ObserverMethodInfo)obj;
            if (this.annotatedMethod == null ? other.annotatedMethod != null : !this.annotatedMethod.equals(other.annotatedMethod)) {
                return false;
            }
            if (this.declaringBeanQualfiers == null ? other.declaringBeanQualfiers != null : !((Object)this.declaringBeanQualfiers).equals(other.declaringBeanQualfiers)) {
                return false;
            }
            if (this.observerParameterQualifier == null ? other.observerParameterQualifier != null : !((Object)this.observerParameterQualifier).equals(other.observerParameterQualifier)) {
                return false;
            }
            return !(this.defaultBeanSynthetic == null ? other.defaultBeanSynthetic != null : !this.defaultBeanSynthetic.equals(other.defaultBeanSynthetic));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultBeanType {
        private final Set<Annotation> qualifiers;
        private final Type type;

        public DefaultBeanType(Set<Annotation> qualifiers, Type type) {
            this.qualifiers = new HashSet<Annotation>(qualifiers);
            this.type = type;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Type getType() {
            return this.type;
        }

        private boolean matches(Bean<?> bean) {
            if (bean.getTypes().contains(this.type)) {
                for (Annotation a : this.qualifiers) {
                    if (bean.getQualifiers().contains(a)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifiers == null ? 0 : ((Object)this.qualifiers).hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultBeanType other = (DefaultBeanType)obj;
            if (this.qualifiers == null ? other.qualifiers != null : !((Object)this.qualifiers).equals(other.qualifiers)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

