/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.bean.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import org.jboss.weld.extensions.bean.BeanBuilder;
import org.jboss.weld.extensions.bean.Beans;
import org.jboss.weld.extensions.bean.ContextualLifecycle;
import org.jboss.weld.extensions.bean.generic.ApplyScope;
import org.jboss.weld.extensions.bean.generic.Generic;
import org.jboss.weld.extensions.bean.generic.GenericConfiguration;
import org.jboss.weld.extensions.bean.generic.GenericManagedBean;
import org.jboss.weld.extensions.bean.generic.GenericMarkerLiteral;
import org.jboss.weld.extensions.bean.generic.GenericObserverMethod;
import org.jboss.weld.extensions.bean.generic.GenericProducerField;
import org.jboss.weld.extensions.bean.generic.GenericProducerMethod;
import org.jboss.weld.extensions.bean.generic.GenericType;
import org.jboss.weld.extensions.bean.generic.InjectGenericLiteral;
import org.jboss.weld.extensions.literal.AnyLiteral;
import org.jboss.weld.extensions.literal.DefaultLiteral;
import org.jboss.weld.extensions.reflection.AnnotationInspector;
import org.jboss.weld.extensions.reflection.Synthetic;
import org.jboss.weld.extensions.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.weld.extensions.reflection.annotated.AnnotationRedefiner;
import org.jboss.weld.extensions.reflection.annotated.RedefinitionContext;
import org.jboss.weld.extensions.unwraps.Unwraps;
import org.jboss.weld.extensions.unwraps.UnwrapsProducerBean;
import org.jboss.weld.extensions.util.collections.Arrays2;
import org.jboss.weld.extensions.util.collections.Multimaps;
import org.jboss.weld.extensions.util.collections.SetMultimap;
import org.jboss.weld.extensions.util.collections.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanExtension
implements Extension {
    private final SetMultimap<Class<? extends Annotation>, BeanHolder<?>> genericBeans = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
    private final SetMultimap<Class<? extends Annotation>, ObserverMethodHolder<?, ?>> genericBeanObserverMethods;
    private final SetMultimap<Class<? extends Annotation>, ProducerMethodHolder<?, ?>> genericBeanProducerMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
    private final SetMultimap<Class<? extends Annotation>, FieldHolder<?, ?>> genericBeanProducerFields;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> genericInjectionTargets;
    private final Map<Annotation, ProducerHolder<?, ?>> genericProducers;
    private final Map<AnnotatedMember<?>, Bean<?>> genericProducerBeans;
    private final SetMultimap<Class<? extends Annotation>, AnnotatedMethod<?>> unwrapsMethods;
    private final Synthetic.Provider annotatedMemberInjectionProvider;
    private final Synthetic genericBeanQualifier;
    private final Set<String> errors;

    private static <T> Supplier<Set<T>> createHashSetSupplier() {
        return new Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return new HashSet();
            }
        };
    }

    public GenericBeanExtension() {
        this.genericBeanObserverMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericBeanProducerFields = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericInjectionTargets = new HashMap();
        this.genericProducers = new HashMap();
        this.genericProducerBeans = new HashMap();
        this.unwrapsMethods = Multimaps.newSetMultimap(new HashMap(), GenericBeanExtension.createHashSetSupplier());
        this.genericBeanQualifier = new Synthetic.SyntheticLiteral("org.jboss.weld.extensions.bean.generic.genericQualifier", 0L);
        this.errors = new HashSet<String>();
        this.annotatedMemberInjectionProvider = new Synthetic.Provider("org.jboss.weld.extensions.bean.generic.annotatedMember");
    }

    <X> void replaceInjectOnGenericBeans(@Observes ProcessAnnotatedType<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)type.getAnnotation(GenericConfiguration.class)).value();
            if (!genericConfigurationType.isAnnotationPresent(GenericType.class)) {
                this.errors.add("Bean " + type.getJavaClass().getName() + " specifies generic annotation " + type.getAnnotation(GenericConfiguration.class) + " however " + genericConfigurationType + " is not annotated @GenericConfiguration.");
            } else {
                Class<?> configType = genericConfigurationType.getAnnotation(GenericType.class).value();
                if (configType.isAnnotationPresent(GenericConfiguration.class)) {
                    this.errors.add("Generic configuration type " + genericConfigurationType + " specifies a value() of " + configType + " however " + configType + " is a generic bean. Generic configuration types may not be generic beans");
                }
            }
            AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass(this.genericBeanQualifier);
            builder.redefine(Inject.class, new AnnotationRedefiner<Inject>(){

                @Override
                public void redefine(RedefinitionContext<Inject> ctx) {
                    if (ctx.getAnnotatedElement() instanceof Field && ctx.getAnnotatedElement().isAnnotationPresent(Generic.class)) {
                        ctx.getAnnotationBuilder().remove(Inject.class).add(InjectGenericLiteral.INSTANCE);
                    }
                }
            });
            builder.redefine(Produces.class, new AnnotationRedefiner<Produces>(){

                @Override
                public void redefine(RedefinitionContext<Produces> ctx) {
                    ctx.getAnnotationBuilder().add(GenericMarkerLiteral.INSTANCE).add(GenericBeanExtension.this.genericBeanQualifier);
                }
            });
            builder.redefine(Generic.class, new AnnotationRedefiner<Generic>(){

                @Override
                public void redefine(RedefinitionContext<Generic> ctx) {
                    if (!(ctx.getAnnotatedElement() instanceof AccessibleObject)) {
                        ctx.getAnnotationBuilder().remove(Generic.class).add(InjectGenericLiteral.INSTANCE);
                        if (ctx.getRawType().isAnnotationPresent(GenericConfiguration.class)) {
                            ctx.getAnnotationBuilder().add(GenericBeanExtension.this.genericBeanQualifier);
                        }
                    }
                }
            });
            event.setAnnotatedType(builder.create());
        }
    }

    <X> void registerGenericBean(@Observes ProcessManagedBean<X> event) {
        AnnotatedType type = event.getAnnotatedBeanClass();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            Class<? extends Annotation> genericType = ((GenericConfiguration)type.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeans.put(genericType, new BeanHolder(event.getAnnotatedBeanClass(), event.getBean()));
            for (AnnotatedMethod m : event.getAnnotatedBeanClass().getMethods()) {
                if (!m.isAnnotationPresent(Unwraps.class)) continue;
                this.unwrapsMethods.put(genericType, m);
            }
        }
    }

    <X, T> void registerGenericBeanProducerMethod(@Observes ProcessProducerMethod<X, T> event) {
        AnnotatedType declaringType = event.getAnnotatedProducerMethod().getDeclaringType();
        Annotation genericConfiguration = GenericBeanExtension.getGenericConfiguration(event.getAnnotated());
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            this.genericBeanProducerMethods.put(((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value(), GenericBeanExtension.getProducerMethodHolder(event));
        } else if (genericConfiguration != null && this.validateGenericProducer(genericConfiguration, (Bean<?>)event.getBean(), (AnnotatedMember<X>)event.getAnnotatedProducerMethod())) {
            this.genericProducerBeans.put((AnnotatedMember<?>)event.getAnnotatedProducerMethod(), (Bean<?>)event.getBean());
        }
    }

    private <X> boolean validateGenericProducer(Annotation genericConfiguration, Bean<?> bean, AnnotatedMember<X> member) {
        Class<?> configType = genericConfiguration.annotationType().getAnnotation(GenericType.class).value();
        boolean valid = false;
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !configType.isAssignableFrom(clazz = (Class)type)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            AnnotatedType declaringType = member.getDeclaringType();
            this.errors.add("Generic producer method is not of correct type. Producer: " + declaringType.getJavaClass().getName() + "." + member.getJavaMember().getName() + ". Expected producer to be of type " + configType + " but was actually " + member.getBaseType());
        }
        return valid;
    }

    private static <X, T> ProducerMethodHolder<X, T> getProducerMethodHolder(ProcessProducerMethod<X, T> event) {
        if (event.getAnnotatedDisposedParameter() instanceof AnnotatedParameter) {
            return new ProducerMethodHolder(event.getAnnotatedProducerMethod(), (AnnotatedMethod)event.getAnnotatedDisposedParameter().getDeclaringCallable(), event.getBean());
        }
        return new ProducerMethodHolder(event.getAnnotatedProducerMethod(), null, event.getBean());
    }

    <T, X> void registerGenericBeanObserverMethod(@Observes ProcessObserverMethod<T, X> event) {
        AnnotatedType declaringType = event.getAnnotatedMethod().getDeclaringType();
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            AnnotatedMethod method = event.getAnnotatedMethod();
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeanObserverMethods.put(genericConfigurationType, new ObserverMethodHolder(method, event.getObserverMethod()));
        }
    }

    <X, T> void registerGenericBeanProducerField(@Observes ProcessProducerField<X, T> event) {
        AnnotatedType declaringType = event.getAnnotatedProducerField().getDeclaringType();
        Annotation genericConfiguration = GenericBeanExtension.getGenericConfiguration(event.getAnnotated());
        if (declaringType.isAnnotationPresent(GenericConfiguration.class)) {
            AnnotatedField field = event.getAnnotatedProducerField();
            Class<? extends Annotation> genericConfigurationType = ((GenericConfiguration)declaringType.getAnnotation(GenericConfiguration.class)).value();
            this.genericBeanProducerFields.put(genericConfigurationType, new FieldHolder(field, event.getBean()));
        } else if (genericConfiguration != null && this.validateGenericProducer(genericConfiguration, (Bean<?>)event.getBean(), (AnnotatedMember<X>)event.getAnnotatedProducerField())) {
            this.genericProducerBeans.put((AnnotatedMember<?>)event.getAnnotatedProducerField(), (Bean<?>)event.getBean());
        }
    }

    <X> void registerGenericBeanInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(GenericConfiguration.class)) {
            this.genericInjectionTargets.put(type, event.getInjectionTarget());
        }
    }

    <X, T> void processGenericProducer(@Observes ProcessProducer<X, T> event, BeanManager beanManager) {
        Annotation genericConfiguration = GenericBeanExtension.getGenericConfiguration((Annotated)event.getAnnotatedMember());
        if (genericConfiguration != null) {
            if (this.genericProducers.containsKey(genericConfiguration)) {
                throw new IllegalStateException("Generic configuration " + genericConfiguration + " is defined twice [" + event.getAnnotatedMember() + ", " + this.genericProducers.get(genericConfiguration).getMember() + "]");
            }
            Producer originalProducer = event.getProducer();
            Class<?> requiredProducerType = genericConfiguration.annotationType().getAnnotation(GenericType.class).value();
            this.genericProducers.put(genericConfiguration, new ProducerHolder(event.getAnnotatedMember(), originalProducer));
        }
    }

    void createGenericBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (Map.Entry<Annotation, ProducerHolder<?, ?>> genericConfigurationEntry : this.genericProducers.entrySet()) {
            Class scopeOverride;
            Class<? extends Annotation> genericConfigurationType;
            Class producerScope = Dependent.class;
            for (Annotation annotation : genericConfigurationEntry.getValue().getMember().getAnnotations()) {
                if (!beanManager.isScope(annotation.annotationType())) continue;
                producerScope = annotation.annotationType();
            }
            ProducerHolder<?, ?> producerHolder = genericConfigurationEntry.getValue();
            Annotation genericConfiguration = genericConfigurationEntry.getKey();
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.addAll(Beans.getQualifiers(beanManager, (Iterable<Annotation>)genericConfigurationEntry.getValue().getMember().getAnnotations()));
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
            }
            if (!this.genericBeans.containsKey(genericConfigurationType = genericConfiguration.annotationType())) {
                throw new IllegalStateException("No generic bean definition exists for " + genericConfigurationType + ", but a generic producer does: " + producerHolder.getMember());
            }
            event.addBean(this.createGenericConfigurationBean(beanManager, genericConfiguration, qualifiers));
            event.addBean(this.createGenericProductAnnotatedMemberBean(beanManager, genericConfiguration, qualifiers));
            boolean alternative = producerHolder.getMember().isAnnotationPresent(Alternative.class);
            Class javaClass = producerHolder.getMember().getDeclaringType().getJavaClass();
            if (this.genericBeanProducerMethods.containsKey(genericConfigurationType)) {
                for (ProducerMethodHolder<?, ?> producerMethodHolder : this.genericBeanProducerMethods.get(genericConfigurationType)) {
                    scopeOverride = null;
                    if (producerMethodHolder.getProducerMethod().isAnnotationPresent(ApplyScope.class)) {
                        scopeOverride = producerScope;
                    }
                    event.addBean(this.createGenericProducerMethod(producerMethodHolder, genericConfiguration, beanManager, scopeOverride, alternative, javaClass));
                }
            }
            if (this.genericBeanProducerFields.containsKey(genericConfigurationType)) {
                for (FieldHolder fieldHolder : this.genericBeanProducerFields.get(genericConfigurationType)) {
                    scopeOverride = null;
                    if (fieldHolder.getField().isAnnotationPresent(ApplyScope.class)) {
                        scopeOverride = producerScope;
                    }
                    event.addBean(this.createGenericProducerField(fieldHolder.getBean(), genericConfiguration, fieldHolder.getField(), beanManager, scopeOverride, alternative, javaClass));
                }
            }
            if (this.genericBeanObserverMethods.containsKey(genericConfigurationType)) {
                for (ObserverMethodHolder observerMethodHolder : this.genericBeanObserverMethods.get(genericConfigurationType)) {
                    event.addObserverMethod(this.createGenericObserverMethod(observerMethodHolder.getObserverMethod(), genericConfiguration, observerMethodHolder.getMethod(), null, beanManager));
                }
            }
            if (this.unwrapsMethods.containsKey(genericConfigurationType)) {
                for (AnnotatedMethod annotatedMethod : this.unwrapsMethods.get(genericConfigurationType)) {
                    AnnotatedMember<?> member = producerHolder.getMember();
                    Set<Annotation> unwrapsQualifiers = Beans.getQualifiers(beanManager, annotatedMethod.getAnnotations(), member.getAnnotations());
                    if (unwrapsQualifiers.isEmpty()) {
                        unwrapsQualifiers.add((Annotation)DefaultLiteral.INSTANCE);
                    }
                    Set<Annotation> beanQualifiers = Beans.getQualifiers(beanManager, annotatedMethod.getDeclaringType().getAnnotations(), member.getAnnotations());
                    beanQualifiers.remove(AnyLiteral.INSTANCE);
                    if (beanQualifiers.isEmpty()) {
                        beanQualifiers.add((Annotation)DefaultLiteral.INSTANCE);
                    }
                    beanQualifiers.remove(this.genericBeanQualifier);
                    event.addBean(new UnwrapsProducerBean(annotatedMethod, unwrapsQualifiers, beanQualifiers, beanManager));
                }
            }
            for (BeanHolder beanHolder : this.genericBeans.get(genericConfigurationType)) {
                scopeOverride = null;
                if (beanHolder.getType().isAnnotationPresent(ApplyScope.class)) {
                    scopeOverride = producerScope;
                }
                Bean genericBean = this.createGenericBean(beanHolder, genericConfiguration, beanManager, scopeOverride, alternative, javaClass);
                event.addBean(genericBean);
            }
        }
    }

    private static Annotation getGenericConfiguration(Annotated annotated) {
        Set<Annotation> genericConfigurationAnnotiations = AnnotationInspector.getAnnotations(annotated, GenericType.class);
        if (genericConfigurationAnnotiations.size() > 1) {
            throw new IllegalStateException("Can only have one generic configuration annotation on " + annotated);
        }
        if (genericConfigurationAnnotiations.size() == 1) {
            return genericConfigurationAnnotiations.iterator().next();
        }
        return null;
    }

    private Bean<?> createGenericConfigurationBean(BeanManager beanManager, final Annotation genericConfiguration, Set<Annotation> qualifiers) {
        BeanBuilder<Annotation> builder = new BeanBuilder(beanManager).beanClass(genericConfiguration.annotationType()).types(Arrays2.asSet(genericConfiguration.annotationType(), Object.class)).scope(Dependent.class).qualifiers(qualifiers).beanLifecycle(new ContextualLifecycle<Annotation>(){

            @Override
            public void destroy(Bean<Annotation> bean, Annotation arg0, CreationalContext<Annotation> arg1) {
            }

            @Override
            public Annotation create(Bean<Annotation> bean, CreationalContext<Annotation> arg0) {
                return genericConfiguration;
            }
        });
        return builder.create();
    }

    private Bean<AnnotatedMember<?>> createGenericProductAnnotatedMemberBean(BeanManager beanManager, Annotation genericConfiguration, Set<Annotation> qualifiers) {
        final ProducerHolder<?, ?> holder = this.genericProducers.get(genericConfiguration);
        BeanBuilder builder = new BeanBuilder(beanManager).beanClass(AnnotatedMember.class).qualifiers(Collections.singleton(this.annotatedMemberInjectionProvider.get(genericConfiguration))).beanLifecycle(new ContextualLifecycle<AnnotatedMember<?>>(){

            @Override
            public void destroy(Bean<AnnotatedMember<?>> bean, AnnotatedMember<?> instance, CreationalContext<AnnotatedMember<?>> ctx) {
            }

            @Override
            public AnnotatedMember<?> create(Bean<AnnotatedMember<?>> bean, CreationalContext<AnnotatedMember<?>> ctx) {
                return holder.getMember();
            }
        });
        return builder.create();
    }

    private <X> Bean<X> createGenericBean(BeanHolder<X> holder, Annotation genericConfiguration, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> beanClass) {
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, genericConfiguration, Collections.EMPTY_SET);
        return new GenericManagedBean<X>(holder.getBean(), genericConfiguration, this.genericInjectionTargets.get(holder.getType()), holder.getType(), declaringBeanQualifiers, scopeOverride, this.annotatedMemberInjectionProvider, alternative, beanClass, beanManager);
    }

    private <X, T> Bean<T> createGenericProducerMethod(ProducerMethodHolder<X, T> holder, Annotation genericConfiguration, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> javaClass) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, genericConfiguration, holder.getBean().getQualifiers());
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, genericConfiguration, Collections.EMPTY_SET);
        return new GenericProducerMethod<T, X>(holder.getBean(), genericConfiguration, holder.getProducerMethod(), holder.getDisposerMethod(), qualifiers, declaringBeanQualifiers, scopeOverride, alternative, javaClass, beanManager);
    }

    public Set<Annotation> getQualifiers(BeanManager beanManager, Annotation genericConfiguration, Iterable<Annotation> annotations) {
        return Beans.getQualifiers(beanManager, this.genericProducers.get(genericConfiguration).getMember().getAnnotations(), annotations);
    }

    private <X, T> ObserverMethod<T> createGenericObserverMethod(ObserverMethod<T> originalObserverMethod, Annotation genericConfiguration, AnnotatedMethod<X> method, Bean<?> genericBean, BeanManager beanManager) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, genericConfiguration, originalObserverMethod.getObservedQualifiers());
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, genericConfiguration, Collections.EMPTY_SET);
        return new GenericObserverMethod<T, X>(originalObserverMethod, method, genericConfiguration, qualifiers, declaringBeanQualifiers, genericBean, beanManager);
    }

    private <X, T> Bean<T> createGenericProducerField(Bean<T> originalBean, Annotation genericConfiguration, AnnotatedField<X> field, BeanManager beanManager, Class<? extends Annotation> scopeOverride, boolean alternative, Class<?> javaClass) {
        Set<Annotation> qualifiers = this.getQualifiers(beanManager, genericConfiguration, originalBean.getQualifiers());
        Set<Annotation> declaringBeanQualifiers = this.getQualifiers(beanManager, genericConfiguration, Collections.EMPTY_SET);
        return new GenericProducerField<T, X>(originalBean, genericConfiguration, field, qualifiers, declaringBeanQualifiers, scopeOverride, alternative, javaClass, beanManager);
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.genericBeanObserverMethods.clear();
        this.genericBeanProducerFields.clear();
        this.genericBeanProducerMethods.clear();
        this.genericBeans.clear();
        this.genericProducers.clear();
        this.genericInjectionTargets.clear();
        for (String s : this.errors) {
            event.addDeploymentProblem((Throwable)new Exception(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObserverMethodHolder<X, T> {
        private final AnnotatedMethod<X> method;
        private final ObserverMethod<T> observerMethod;

        private ObserverMethodHolder(AnnotatedMethod<X> method, ObserverMethod<T> observerMethod) {
            this.method = method;
            this.observerMethod = observerMethod;
        }

        public AnnotatedMethod<X> getMethod() {
            return this.method;
        }

        public ObserverMethod<T> getObserverMethod() {
            return this.observerMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldHolder<X, T> {
        private final AnnotatedField<X> field;
        private final Bean<T> bean;

        private FieldHolder(AnnotatedField<X> field, Bean<T> bean) {
            this.field = field;
            this.bean = bean;
        }

        public AnnotatedField<X> getField() {
            return this.field;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProducerHolder<X, T> {
        private final AnnotatedMember<X> member;
        private final Producer<T> producer;

        private ProducerHolder(AnnotatedMember<X> method, Producer<T> producer) {
            this.member = method;
            this.producer = producer;
        }

        public AnnotatedMember<X> getMember() {
            return this.member;
        }

        public Producer<T> getProducer() {
            return this.producer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProducerMethodHolder<X, T> {
        private final AnnotatedMethod<X> producerMethod;
        private final AnnotatedMethod<X> disposerMethod;
        private final Bean<T> bean;

        private ProducerMethodHolder(AnnotatedMethod<X> producerMethod, AnnotatedMethod<X> disposerMethod, Bean<T> bean) {
            this.producerMethod = producerMethod;
            this.disposerMethod = disposerMethod;
            this.bean = bean;
        }

        public AnnotatedMethod<X> getProducerMethod() {
            return this.producerMethod;
        }

        public AnnotatedMethod<X> getDisposerMethod() {
            return this.disposerMethod;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanHolder<T> {
        private final AnnotatedType<T> type;
        private final Bean<T> bean;

        private BeanHolder(AnnotatedType<T> type, Bean<T> bean) {
            this.type = type;
            this.bean = bean;
        }

        public AnnotatedType<T> getType() {
            return this.type;
        }

        public Bean<T> getBean() {
            return this.bean;
        }
    }
}

