/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.bean.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.extensions.bean.ForwardingObserverMethod;
import org.jboss.weld.extensions.literal.AnyLiteral;
import org.jboss.weld.extensions.reflection.annotated.InjectableMethod;
import org.jboss.weld.extensions.reflection.annotated.ParameterValueRedefiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericObserverMethod<T, X>
extends ForwardingObserverMethod<T> {
    private final ObserverMethod<T> originalObserverMethod;
    private final InjectableMethod<X> observerMethod;
    private final BeanManager beanManager;
    private final Type declaringBeanType;
    private final Annotation[] declaringBeanQualifiers;
    private final Set<Annotation> qualifiers;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    GenericObserverMethod(ObserverMethod<T> originalObserverMethod, AnnotatedMethod<X> observerMethod, Annotation declaringBeanQualifier, Set<Annotation> qualifiers, Set<Annotation> declaringBeanQualifiers, Bean<?> genericBean, BeanManager beanManager) {
        this.originalObserverMethod = originalObserverMethod;
        this.observerMethod = new InjectableMethod<X>(observerMethod, genericBean, beanManager);
        this.beanManager = beanManager;
        this.declaringBeanType = originalObserverMethod.getBeanClass();
        this.qualifiers = qualifiers;
        HashSet<Annotation> filteredDeclaringBeanQualifiers = new HashSet<Annotation>(declaringBeanQualifiers);
        filteredDeclaringBeanQualifiers.remove(AnyLiteral.INSTANCE);
        this.declaringBeanQualifiers = filteredDeclaringBeanQualifiers.toArray(EMPTY_ANNOTATION_ARRAY);
    }

    @Override
    protected ObserverMethod<T> delegate() {
        return this.originalObserverMethod;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this.qualifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(final T event) {
        Bean declaringBean = this.beanManager.resolve(this.beanManager.getBeans(this.declaringBeanType, this.declaringBeanQualifiers));
        final CreationalContext<?> creationalContext = this.createCreationalContext(declaringBean);
        try {
            Object instance = this.beanManager.getReference(declaringBean, this.declaringBeanType, creationalContext);
            if (instance == null) {
                return;
            }
            this.observerMethod.invoke(instance, creationalContext, new ParameterValueRedefiner(){

                public Object redefineParameterValue(ParameterValueRedefiner.ParameterValue value) {
                    if (value.getInjectionPoint().getAnnotated().isAnnotationPresent(Observes.class)) {
                        return event;
                    }
                    return value.getDefaultValue(creationalContext);
                }
            });
        }
        finally {
            if (creationalContext != null) {
                creationalContext.release();
            }
        }
    }

    private CreationalContext<?> createCreationalContext(Bean<?> declaringBean) {
        if (this.getReception().equals((Object)Reception.ALWAYS)) {
            return this.beanManager.createCreationalContext(declaringBean);
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenericObserverMethod) {
            GenericObserverMethod that = (GenericObserverMethod)obj;
            return this.delegate().equals(that.delegate()) && this.getObservedType().equals(that.getObservedType()) && ((Object)this.getObservedQualifiers()).equals(that.getObservedQualifiers());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 31 * hash + this.getObservedType().hashCode();
        hash = 31 * hash + ((Object)this.getObservedQualifiers()).hashCode();
        return hash;
    }
}

