/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.beanManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.weld.extensions.beanManager.BeanManagerProvider;
import org.jboss.weld.extensions.util.Sortable;
import org.jboss.weld.extensions.util.service.ServiceLoader;

public class BeanManagerAware {
    @Inject
    private BeanManager beanManager;
    private final List<BeanManagerProvider> beanManagerProviders = new ArrayList<BeanManagerProvider>();

    private void loadServices() {
        this.beanManagerProviders.clear();
        Iterator<BeanManagerProvider> providers = ServiceLoader.load(BeanManagerProvider.class).iterator();
        while (providers.hasNext()) {
            this.beanManagerProviders.add(providers.next());
        }
    }

    protected BeanManagerAware() {
    }

    protected BeanManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = this.lookupBeanManager();
        }
        if (this.beanManager == null) {
            throw new IllegalStateException("Could not locate a BeanManager from the providers " + this.providersToString());
        }
        return this.beanManager;
    }

    protected boolean isBeanManagerAvailable() {
        if (this.beanManager == null) {
            return this.lookupBeanManager() != null;
        }
        return true;
    }

    private String providersToString() {
        StringBuffer out = new StringBuffer();
        int i = 0;
        for (BeanManagerProvider provider : this.beanManagerProviders) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(provider.getClass().getName());
            out.append("(");
            out.append(provider.getPrecedence());
            out.append(")");
            ++i;
        }
        return out.toString();
    }

    private BeanManager lookupBeanManager() {
        BeanManagerProvider provider;
        BeanManager beanManager = null;
        if (this.beanManagerProviders.isEmpty()) {
            this.loadServices();
            Collections.sort(this.beanManagerProviders, new Sortable.Comparator());
        }
        Iterator<BeanManagerProvider> i$ = this.beanManagerProviders.iterator();
        while (i$.hasNext() && (beanManager = (provider = i$.next()).getBeanManager()) == null) {
        }
        return beanManager;
    }
}

