/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Named;
import org.jboss.weld.extensions.core.Exact;
import org.jboss.weld.extensions.core.Requires;
import org.jboss.weld.extensions.core.Veto;
import org.jboss.weld.extensions.literal.NamedLiteral;
import org.jboss.weld.extensions.reflection.Reflections;
import org.jboss.weld.extensions.reflection.annotated.AnnotatedTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreExtension
implements Extension {
    private final Collection<Bean<?>> additionalBeans = new ArrayList();
    static final Logger log = LoggerFactory.getLogger(CoreExtension.class);

    CoreExtension() {
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        Class<?> type;
        if (pat.getAnnotatedType().isAnnotationPresent(Veto.class)) {
            pat.veto();
            log.info("Preventing " + pat.getAnnotatedType().getJavaClass() + " from being installed as bean due to @Veto annotation");
            return;
        }
        if (pat.getAnnotatedType().isAnnotationPresent(Requires.class)) {
            String[] classes;
            for (String i : classes = ((Requires)pat.getAnnotatedType().getAnnotation(Requires.class)).value()) {
                try {
                    Reflections.classForName(i, pat.getAnnotatedType().getJavaClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    log.info("Preventing " + pat.getAnnotatedType().getJavaClass() + " from being installed as required class " + i + " could not be found");
                    pat.veto();
                }
                catch (LinkageError e) {
                    log.info("Preventing " + pat.getAnnotatedType().getJavaClass() + " from being installed as a linkage error occurred loading required class " + i + ". The linkage error was " + e.toString());
                    pat.veto();
                }
            }
        }
        AnnotatedTypeBuilder builder = null;
        Package pkg = pat.getAnnotatedType().getJavaClass().getPackage();
        if (pkg.isAnnotationPresent(Named.class) && !pat.getAnnotatedType().isAnnotationPresent(Named.class)) {
            if (builder == null) {
                builder = new AnnotatedTypeBuilder().readFromType(pat.getAnnotatedType());
            }
            builder.addToClass((Annotation)((Object)new NamedLiteral("")));
        }
        for (AnnotatedField f : pat.getAnnotatedType().getFields()) {
            if (!f.isAnnotationPresent(Exact.class)) continue;
            Class<?> type2 = ((Exact)f.getAnnotation(Exact.class)).value();
            if (builder == null) {
                builder = new AnnotatedTypeBuilder().readFromType(pat.getAnnotatedType());
            }
            builder.overrideFieldType(f, type2);
        }
        for (AnnotatedMethod m : pat.getAnnotatedType().getMethods()) {
            for (AnnotatedParameter p : m.getParameters()) {
                if (!p.isAnnotationPresent(Exact.class)) continue;
                type = ((Exact)p.getAnnotation(Exact.class)).value();
                if (builder == null) {
                    builder = new AnnotatedTypeBuilder().readFromType(pat.getAnnotatedType());
                }
                builder.overrideParameterType(p, type);
            }
        }
        for (AnnotatedConstructor c : pat.getAnnotatedType().getConstructors()) {
            for (AnnotatedParameter p : c.getParameters()) {
                if (!p.isAnnotationPresent(Exact.class)) continue;
                type = ((Exact)p.getAnnotation(Exact.class)).value();
                if (builder == null) {
                    builder = new AnnotatedTypeBuilder().readFromType(pat.getAnnotatedType());
                }
                builder.overrideParameterType(p, type);
            }
        }
        if (builder != null) {
            pat.setAnnotatedType(builder.create());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) {
        for (Bean<?> bean : this.additionalBeans) {
            abd.addBean(bean);
        }
    }
}

