/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.log;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.MessageLogger;
import org.jboss.weld.extensions.bean.NarrowingBeanBuilder;
import org.jboss.weld.extensions.log.MessageBundleLiteral;
import org.jboss.weld.extensions.log.Producers;
import org.jboss.weld.extensions.log.TypedLogger;
import org.jboss.weld.extensions.log.TypedMessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerExtension
implements Extension {
    private final Collection<AnnotatedType<?>> messageLoggerTypes = new HashSet();
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> loggerProducerBean;
    private Bean<Object> bundleProducerBean;

    LoggerExtension() {
    }

    void addProducer(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addAnnotatedType(beanManager.createAnnotatedType(Producers.class));
    }

    void detectInterfaces(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(MessageLogger.class)) {
            this.messageLoggerTypes.add(type);
        }
        if (type.isAnnotationPresent(MessageBundle.class)) {
            this.messageBundleTypes.add(type);
        }
    }

    void detectProducers(@Observes ProcessProducerMethod<Producers, Object> event) {
        if (event.getAnnotatedProducerMethod().isAnnotationPresent(TypedLogger.class)) {
            this.loggerProducerBean = event.getBean();
        }
        if (event.getAnnotatedProducerMethod().isAnnotationPresent(TypedMessageBundle.class)) {
            this.bundleProducerBean = event.getBean();
        }
    }

    void installBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType<?> type : this.messageLoggerTypes) {
            event.addBean(LoggerExtension.createMessageLoggerBean(this.loggerProducerBean, type, beanManager));
        }
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            event.addBean(LoggerExtension.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
        }
    }

    private static <T> Bean<T> createMessageLoggerBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).create();
    }

    private static <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).addQualifier(MessageBundleLiteral.INSTANCE).create();
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.messageLoggerTypes.clear();
        this.messageBundleTypes.clear();
    }

    static {
        System.setProperty("jboss.i18n.generate-proxies", "true");
    }
}

