/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.log;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.weld.extensions.log.Category;
import org.jboss.weld.extensions.log.Locale;
import org.jboss.weld.extensions.log.Suffix;
import org.jboss.weld.extensions.log.TypedLogger;
import org.jboss.weld.extensions.log.TypedMessageBundle;
import org.jboss.weld.extensions.reflection.Reflections;
import org.jboss.weld.extensions.util.Locales;

class Producers {
    Producers() {
    }

    @Produces
    Logger produceLog(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class) && annotated.isAnnotationPresent(Suffix.class)) {
            return Logger.getLogger((String)((Category)annotated.getAnnotation(Category.class)).value(), (String)((Suffix)annotated.getAnnotation(Suffix.class)).value());
        }
        if (annotated.isAnnotationPresent(Category.class)) {
            return Logger.getLogger((String)((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(Suffix.class)) {
            return Logger.getLogger(Reflections.getRawType(injectionPoint.getType()), (String)((Suffix)annotated.getAnnotation(Suffix.class)).value());
        }
        return Logger.getLogger(Reflections.getRawType(injectionPoint.getType()));
    }

    @Produces
    @TypedLogger
    Object produceTypedLogger(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (!annotated.isAnnotationPresent(Category.class)) {
            throw new IllegalStateException("Must specify @Category for typed loggers at [" + injectionPoint + "]");
        }
        if (annotated.isAnnotationPresent(Locale.class)) {
            return Logger.getMessageLogger(Reflections.getRawType(injectionPoint.getType()), (String)((Category)annotated.getAnnotation(Category.class)).value(), (java.util.Locale)Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
        }
        return Logger.getMessageLogger(Reflections.getRawType(injectionPoint.getType()), (String)((Category)annotated.getAnnotation(Category.class)).value());
    }

    @Produces
    @TypedMessageBundle
    Object produceTypedMessageBundle(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Locale.class)) {
            return Messages.getBundle(Reflections.getRawType(injectionPoint.getType()), (java.util.Locale)Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
        }
        return Messages.getBundle(Reflections.getRawType(injectionPoint.getType()));
    }
}

