/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.properties;

import java.beans.Introspector;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.weld.extensions.properties.MethodProperty;
import org.jboss.weld.extensions.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodPropertyImpl<V>
implements MethodProperty<V> {
    private final Method getterMethod;
    private final String propertyName;
    private final Method setterMethod;

    public MethodPropertyImpl(Method method) {
        if (method.getName().startsWith("get")) {
            this.propertyName = Introspector.decapitalize(method.getName().substring(3));
        } else if (method.getName().startsWith("set")) {
            this.propertyName = Introspector.decapitalize(method.getName().substring(3));
        } else if (method.getName().startsWith("is")) {
            this.propertyName = Introspector.decapitalize(method.getName().substring(2));
        } else {
            throw new IllegalArgumentException("Invalid accessor method, must start with 'get', 'set' or 'is'.  Method: " + method);
        }
        this.getterMethod = MethodPropertyImpl.getGetterMethod(method.getDeclaringClass(), this.propertyName);
        this.setterMethod = MethodPropertyImpl.getSetterMethod(method.getDeclaringClass(), this.propertyName);
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Class<V> getJavaClass() {
        return this.getterMethod.getReturnType();
    }

    @Override
    public Type getBaseType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public Method getAnnotatedElement() {
        return this.getterMethod;
    }

    @Override
    public Member getMember() {
        return this.getterMethod;
    }

    @Override
    public V getValue(Object instance) {
        return this.getJavaClass().cast(Reflections.invokeMethod(this.getterMethod, instance, new Object[0]));
    }

    @Override
    public void setValue(Object instance, V value) {
        Reflections.invokeMethod(this.setterMethod, instance, value);
    }

    private static Method getSetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || !Introspector.decapitalize(methodName.substring(3)).equals(name)) continue;
            return method;
        }
        return null;
    }

    private static Method getGetterMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0 || !(methodName.startsWith("get") ? Introspector.decapitalize(methodName.substring(3)).equals(name) : methodName.startsWith("is") && Introspector.decapitalize(methodName.substring(2)).equals(name))) continue;
            return method;
        }
        throw new IllegalArgumentException("no such getter method: " + clazz.getName() + '.' + name);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getterMethod.getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return this.setterMethod == null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReadOnly()) {
            builder.append("read-only ").append(this.setterMethod.toString()).append("; ");
        }
        builder.append(this.getterMethod.toString());
        return builder.toString();
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.setterMethod == null ? 0 : this.setterMethod.hashCode());
        hash = hash * 31 + this.getterMethod.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodPropertyImpl) {
            MethodPropertyImpl that = (MethodPropertyImpl)obj;
            if (this.setterMethod == null) {
                return that.setterMethod == null && this.getterMethod.equals(that.getterMethod);
            }
            return this.setterMethod.equals(that.setterMethod) && this.getterMethod.equals(that.getterMethod);
        }
        return false;
    }
}

