/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.properties.query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.extensions.properties.FieldProperty;
import org.jboss.weld.extensions.properties.Properties;
import org.jboss.weld.extensions.properties.Property;
import org.jboss.weld.extensions.properties.query.PropertyCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyQuery<V> {
    private final Class<?> targetClass;
    private final List<PropertyCriteria> criteria;

    PropertyQuery(Class<?> targetClass) {
        this.targetClass = targetClass;
        this.criteria = new ArrayList<PropertyCriteria>();
    }

    public PropertyQuery<V> addCriteria(PropertyCriteria criteria) {
        this.criteria.add(criteria);
        return this;
    }

    public Property<V> getFirstResult() {
        List<Property<V>> results = this.getResultList();
        return results.isEmpty() ? null : results.get(0);
    }

    public List<Property<V>> getResultList() {
        ArrayList<Property<V>> results = new ArrayList<Property<V>>();
        for (Method method : this.targetClass.getMethods()) {
            if (!method.getName().startsWith("is") && !method.getName().startsWith("get")) continue;
            boolean match = true;
            for (PropertyCriteria c : this.criteria) {
                if (c.methodMatches(method)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            results.add(Properties.createProperty(method));
        }
        Class<?> cls = this.targetClass;
        while (!cls.equals(Object.class)) {
            for (Field field : cls.getDeclaredFields()) {
                boolean match = true;
                for (PropertyCriteria c : this.criteria) {
                    if (c.fieldMatches(field)) continue;
                    match = false;
                    break;
                }
                FieldProperty prop = Properties.createProperty(field);
                if (!match || this.resultsContainsProperty(results, prop.getName())) continue;
                results.add(prop);
            }
            cls = cls.getSuperclass();
        }
        return results;
    }

    private boolean resultsContainsProperty(List<Property<V>> results, String propertyName) {
        for (Property<V> p : results) {
            if (!propertyName.equals(p.getName())) continue;
            return true;
        }
        return false;
    }
}

