/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.reflection;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;

@Retention(value=RetentionPolicy.RUNTIME)
@Qualifier
public @interface Synthetic {
    public long index();

    public String namespace();

    public static class Provider {
        private final Map<Annotation, Synthetic> synthetics = new HashMap<Annotation, Synthetic>();
        private final String namespace;
        private AtomicLong count;

        public Provider(String namespace) {
            this.namespace = namespace;
            this.count = new AtomicLong();
        }

        public Synthetic get(Annotation annotation) {
            if (!this.synthetics.containsKey(annotation)) {
                this.synthetics.put(annotation, new SyntheticLiteral(this.namespace, this.count.getAndIncrement()));
            }
            return this.synthetics.get(annotation);
        }

        public Synthetic get() {
            return new SyntheticLiteral(this.namespace, this.count.getAndIncrement());
        }

        public void clear() {
            this.synthetics.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyntheticLiteral
    extends AnnotationLiteral<Synthetic>
    implements Synthetic {
        private final Long index;
        private final String namespace;

        public SyntheticLiteral(String namespace, Long index) {
            this.namespace = namespace;
            this.index = index;
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }
    }
}

