/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.reflection.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.jboss.weld.extensions.reflection.HierarchyDiscovery;
import org.jboss.weld.extensions.reflection.annotated.AnnotationStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AnnotatedImpl
implements Annotated {
    private final Type type;
    private final Set<Type> typeClosure;
    private final AnnotationStore annotations;

    protected AnnotatedImpl(Class<?> type, AnnotationStore annotations, Type genericType, Type overridenType) {
        if (overridenType == null) {
            if (genericType != null) {
                this.typeClosure = new HierarchyDiscovery(genericType).getTypeClosure();
                this.type = genericType;
            } else {
                this.typeClosure = new HierarchyDiscovery(type).getTypeClosure();
                this.type = type;
            }
        } else {
            this.type = overridenType;
            this.typeClosure = Collections.singleton(overridenType);
        }
        this.annotations = annotations == null ? new AnnotationStore() : annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.annotations.getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations.getAnnotations();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.isAnnotationPresent(annotationType);
    }

    public Set<Type> getTypeClosure() {
        return new HashSet<Type>(this.typeClosure);
    }

    public Type getBaseType() {
        return this.type;
    }
}

