/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.extensions.unwraps;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.weld.extensions.reflection.Reflections;
import org.jboss.weld.extensions.servicehandler.ServiceHandlerExtension;
import org.jboss.weld.extensions.unwraps.Unwraps;
import org.jboss.weld.extensions.unwraps.UnwrapsProducerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnwrapsExtension
implements Extension {
    private final Set<Bean<?>> beans;
    private static final Logger log = LoggerFactory.getLogger(UnwrapsExtension.class);
    private final boolean enabled;
    private final Set<Throwable> problems = new HashSet<Throwable>();

    public UnwrapsExtension() {
        this.beans = new HashSet();
        boolean en = true;
        try {
            Reflections.classForName("javassist.util.proxy.MethodHandler", ServiceHandlerExtension.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            en = false;
            log.debug("Javassist not preset, @Unwraps is disabled");
        }
        this.enabled = en;
    }

    void processAnnotatedType(@Observes ProcessAnnotatedType<?> type, BeanManager beanManager) {
        for (AnnotatedMethod method : type.getAnnotatedType().getMethods()) {
            if (!method.isAnnotationPresent(Unwraps.class)) continue;
            if (!this.enabled) {
                this.problems.add(new RuntimeException("Javassist not found on the class path, @Unwraps requires javassist to work. @Unwraps found on " + type.getAnnotatedType().getJavaClass().getName() + "." + method.getJavaMember().getName()));
                continue;
            }
            this.beans.add(UnwrapsExtension.createBean(method, beanManager));
        }
    }

    private static <X> Bean<X> createBean(AnnotatedMethod<X> method, BeanManager beanManager) {
        return new UnwrapsProducerBean(method, beanManager);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBean) {
        for (Bean<?> b : this.beans) {
            afterBean.addBean(b);
        }
        for (Throwable e : this.problems) {
            afterBean.addDefinitionError(e);
        }
    }
}

