/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.weld.junit4.WeldJunit4Extension;

public class MockBean<T>
implements Bean<T>,
PassivationCapable {
    private static final AtomicInteger SEQUENCE = new AtomicInteger(0);
    private final Set<Class<? extends Annotation>> stereotypes;
    private final boolean alternative;
    private final String name;
    private final Set<Annotation> qualifiers;
    private final Set<Type> types;
    private final Class<? extends Annotation> scope;
    private final CreateFunction<T> createCallback;
    private final DestroyFunction<T> destroyCallback;
    private final String id;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Bean<T> of(T beanInstance, Type ... beanTypes) {
        return MockBean.builder().types(beanTypes).creating(beanInstance).build();
    }

    private MockBean(Set<Class<? extends Annotation>> stereotypes, boolean alternative, String name, Set<Annotation> qualifiers, Set<Type> types, Class<? extends Annotation> scope, CreateFunction<T> createCallback, DestroyFunction<T> destroyCallback) {
        this.stereotypes = stereotypes;
        this.alternative = alternative;
        this.name = name;
        this.qualifiers = qualifiers;
        this.types = types;
        this.scope = scope;
        this.createCallback = createCallback;
        this.destroyCallback = destroyCallback;
        this.id = MockBean.class.getName() + "_" + SEQUENCE.incrementAndGet();
    }

    public T create(CreationalContext<T> creationalContext) {
        return this.createCallback.create(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.destroyCallback != null) {
            this.destroyCallback.destroy(instance, creationalContext);
        }
    }

    public Class<?> getBeanClass() {
        return WeldJunit4Extension.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public String getId() {
        return this.id;
    }

    static class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        public static final Default INSTANCE = new DefaultLiteral();

        private DefaultLiteral() {
        }
    }

    static class AnyLiteral
    extends AnnotationLiteral<Any>
    implements Any {
        private static final long serialVersionUID = 1L;
        public static final Any INSTANCE = new AnyLiteral();

        private AnyLiteral() {
        }
    }

    public static interface DestroyFunction<T> {
        public void destroy(T var1, CreationalContext<T> var2);
    }

    public static interface CreateFunction<T> {
        public T create(CreationalContext<T> var1);
    }

    public static class Builder<T> {
        private Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        private boolean alternative = false;
        private String name;
        private Set<Annotation> qualifiers = new HashSet<Annotation>();
        private Set<Type> types;
        private Class<? extends Annotation> scope;
        private CreateFunction<T> createCallback;
        private DestroyFunction<T> destroyCallback;

        private Builder() {
            this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            this.scope = Dependent.class;
            this.types = new HashSet<Type>();
            this.types.add((Type)((Object)Object.class));
        }

        public Builder<T> scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> types(Type ... types) {
            this.types = new HashSet<Type>();
            Collections.addAll(this.types, types);
            return this;
        }

        public Builder<T> qualifiers(Annotation ... qualifiers) {
            this.qualifiers = new HashSet<Annotation>();
            Collections.addAll(this.qualifiers, qualifiers);
            return this;
        }

        public Builder<T> alternative(boolean value) {
            this.alternative = value;
            return this;
        }

        public Builder<T> stereotypes(Class<? extends Annotation> ... stereotypes) {
            this.stereotypes = new HashSet<Class<? extends Annotation>>();
            Collections.addAll(this.stereotypes, stereotypes);
            return this;
        }

        public Builder<T> creating(final T instance) {
            this.createCallback = new CreateFunction<T>(){

                @Override
                public T create(CreationalContext<T> creationalContext) {
                    return instance;
                }
            };
            return this;
        }

        public Builder<T> create(CreateFunction<T> callback) {
            this.createCallback = callback;
            return this;
        }

        public Builder<T> destroy(DestroyFunction<T> callback) {
            this.destroyCallback = callback;
            return this;
        }

        public MockBean<T> build() {
            if (this.createCallback == null) {
                throw new IllegalStateException("Create callback must not be null");
            }
            if (this.qualifiers.size() == 1) {
                this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
            }
            return new MockBean(this.stereotypes, this.alternative, this.name, this.qualifiers, this.types, this.scope, this.createCallback, this.destroyCallback);
        }
    }
}

