/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit4;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.junit4.WeldJunit4Extension;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WeldInitiator
implements TestRule,
WeldInstance<Object>,
ContainerInstance {
    private final Weld weld;
    private final List<Object> instancesToInject;
    private final Set<Class<? extends Annotation>> scopesToActivate;
    private final Set<Bean<?>> beans;
    private final WeldJunit4Extension extension;
    private volatile WeldContainer container;

    public static WeldInitiator of(Class<?> ... beanClasses) {
        return WeldInitiator.of(WeldInitiator.createWeld().beanClasses((Class[])beanClasses));
    }

    public static WeldInitiator of(Weld weld) {
        return new WeldInitiator(weld, null, null, null);
    }

    public static WeldInitiator ofTestPackage() {
        return new WeldInitiator(null, null, null, null);
    }

    public static Weld createWeld() {
        return new Weld().disableDiscovery().property(ConfigurationKey.CONCURRENT_DEPLOYMENT.get(), (Object)false);
    }

    public static Builder from(Class<?> ... beanClasses) {
        return WeldInitiator.from(WeldInitiator.createWeld().beanClasses((Class[])beanClasses));
    }

    public static Builder from(Weld weld) {
        return new Builder(weld);
    }

    public static Builder fromTestPackage() {
        return new Builder(null);
    }

    private WeldInitiator(Weld weld, List<Object> instancesToInject, Set<Class<? extends Annotation>> scopesToActivate, Set<Bean<?>> beans) {
        this.instancesToInject = instancesToInject;
        this.scopesToActivate = scopesToActivate;
        this.beans = beans;
        this.weld = weld;
        if (this.hasScopesToActivate() || this.hasBeansToAdd()) {
            this.extension = new WeldJunit4Extension(this.scopesToActivate, this.beans);
            this.weld.addExtension((Extension)this.extension);
        } else {
            this.extension = null;
        }
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Weld weld = WeldInitiator.this.weld;
                if (weld == null) {
                    weld = WeldInitiator.createWeld().addPackage(false, description.getTestClass());
                }
                WeldInitiator.this.container = weld.initialize();
                WeldInitiator.this.injectInstances();
                if (WeldInitiator.this.extension != null) {
                    WeldInitiator.this.extension.activateContexts();
                }
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        if (WeldInitiator.this.extension != null) {
                            WeldInitiator.this.extension.deactivateContexts();
                        }
                    }
                    finally {
                        if (WeldInitiator.this.container != null && WeldInitiator.this.container.isRunning()) {
                            WeldInitiator.this.container.shutdown();
                        }
                    }
                }
            }
        };
    }

    public Iterator<Object> iterator() {
        this.checkContainer();
        return this.container.iterator();
    }

    public Object get() {
        this.checkContainer();
        return this.container.get();
    }

    public WeldInstance<Object> select(Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(qualifiers);
    }

    public <U> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(subtype, qualifiers);
    }

    public <U> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(subtype, qualifiers);
    }

    public boolean isUnsatisfied() {
        this.checkContainer();
        return this.container.isUnsatisfied();
    }

    public boolean isAmbiguous() {
        this.checkContainer();
        return this.container.isAmbiguous();
    }

    public WeldInstance.Handler<Object> getHandler() {
        this.checkContainer();
        return this.container.getHandler();
    }

    public boolean isResolvable() {
        this.checkContainer();
        return this.container.isResolvable();
    }

    public Iterable<WeldInstance.Handler<Object>> handlers() {
        this.checkContainer();
        return this.container.handlers();
    }

    public void destroy(Object instance) {
        this.checkContainer();
        this.container.destroy(instance);
    }

    public Event<Object> event() {
        this.checkContainer();
        return this.container.event();
    }

    public BeanManager getBeanManager() {
        this.checkContainer();
        return this.container.getBeanManager();
    }

    public String getId() {
        return this.container.getId();
    }

    public void shutdown() {
        this.container.shutdown();
    }

    public boolean isRunning() {
        return this.container.isRunning();
    }

    private void checkContainer() {
        if (this.container == null || !this.container.isRunning()) {
            throw new IllegalStateException("Weld container is not running");
        }
    }

    private void injectInstances() {
        if (this.instancesToInject == null || this.instancesToInject.isEmpty()) {
            return;
        }
        for (Object instance : this.instancesToInject) {
            BeanManager beanManager = this.container.getBeanManager();
            CreationalContext ctx = beanManager.createCreationalContext(null);
            InjectionTarget injectionTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(instance.getClass()));
            injectionTarget.inject(instance, ctx);
        }
    }

    private boolean hasScopesToActivate() {
        return this.scopesToActivate != null && !this.scopesToActivate.isEmpty();
    }

    private boolean hasBeansToAdd() {
        return this.beans != null && !this.beans.isEmpty();
    }

    public static final class Builder {
        private final Weld weld;
        private final List<Object> instancesToInject;
        private final Set<Class<? extends Annotation>> scopesToActivate;
        private final Set<Bean<?>> beans;

        public Builder(Weld weld) {
            this.weld = weld;
            this.instancesToInject = new ArrayList<Object>();
            this.scopesToActivate = new HashSet<Class<? extends Annotation>>();
            this.beans = new HashSet();
        }

        @SafeVarargs
        public final Builder activate(Class<? extends Annotation> ... normalScopes) {
            for (Class<? extends Annotation> scope : normalScopes) {
                if (ApplicationScoped.class.equals(scope)) continue;
                if (!scope.isAnnotationPresent(NormalScope.class)) {
                    throw new IllegalArgumentException("Only annotations annotated with @NormalScope are supported!");
                }
                this.scopesToActivate.add(scope);
            }
            return this;
        }

        public Builder inject(Object instance) {
            this.instancesToInject.add(instance);
            return this;
        }

        public Builder addBeans(Bean<?> ... beans) {
            Collections.addAll(this.beans, beans);
            return this;
        }

        public WeldInitiator build() {
            return new WeldInitiator(this.weld, this.instancesToInject.isEmpty() ? null : new ArrayList<Object>(this.instancesToInject), this.scopesToActivate.isEmpty() ? null : new HashSet<Class<? extends Annotation>>(this.scopesToActivate), this.beans.isEmpty() ? null : new HashSet(this.beans));
        }
    }
}

