/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.junit.AbstractWeldInitiator;
import org.jboss.weld.junit5.ExplicitParamInjection;
import org.jboss.weld.junit5.WeldInitiator;
import org.jboss.weld.junit5.WeldSetup;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class WeldJunit5Extension
implements AfterAllCallback,
TestInstancePostProcessor,
AfterTestExecutionCallback,
ParameterResolver {
    private static final String INITIATOR = "weldInitiator";
    private static final String CONTAINER = "weldContainer";
    private static final String EXPLICIT_PARAM_INJECTION = "explicitParamInjection";
    public static final String GLOBAL_EXPLICIT_PARAM_INJECTION = "org.jboss.weld.junit5.explicitParamInjection";

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.determineTestLifecycle(context).equals((Object)TestInstance.Lifecycle.PER_CLASS)) {
            this.getInitiatorFromStore(context).shutdownWeld();
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        if (this.determineTestLifecycle(context).equals((Object)TestInstance.Lifecycle.PER_METHOD)) {
            this.getInitiatorFromStore(context).shutdownWeld();
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.storeExplicitParamResolutionInformation(context);
        WeldInitiator initiator = null;
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            Object fieldInstance;
            if (!field.isAnnotationPresent(WeldSetup.class)) continue;
            if (initiator != null) {
                throw new IllegalStateException("Multiple @WeldSetup annotated fields found, please use only one such field.");
            }
            try {
                fieldInstance = field.get(testInstance);
            }
            catch (IllegalAccessException e) {
                field.setAccessible(true);
                fieldInstance = field.get(testInstance);
            }
            if (fieldInstance != null && fieldInstance instanceof WeldInitiator) {
                initiator = (WeldInitiator)((Object)fieldInstance);
                continue;
            }
            throw new IllegalStateException("@WeldSetup annotation should only be used on a field of type WeldInitiator.");
        }
        if (initiator == null) {
            initiator = (WeldInitiator)WeldInitiator.from(AbstractWeldInitiator.createWeld().addPackage(false, testInstance.getClass())).build();
        }
        this.getStore(context).put((Object)INITIATOR, initiator);
        this.getStore(context).put((Object)CONTAINER, (Object)initiator.initWeld(testInstance));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.getContainerFromStore(extensionContext) != null) {
            List<Annotation> qualifiers = this.resolveQualifiers(parameterContext, this.getContainerFromStore(extensionContext).getBeanManager());
            return this.getContainerFromStore(extensionContext).select(parameterContext.getParameter().getType(), qualifiers.toArray(new Annotation[qualifiers.size()])).get();
        }
        return null;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.getContainerFromStore(extensionContext) == null || !(parameterContext.getDeclaringExecutable() instanceof Method)) {
            return false;
        }
        List<Annotation> qualifiers = this.resolveQualifiers(parameterContext, this.getContainerFromStore(extensionContext).getBeanManager());
        if ((this.getExplicitInjectionInfoFromStore(extensionContext).booleanValue() || this.methodRequiresExplicitParamInjection(parameterContext)) && qualifiers.isEmpty()) {
            return false;
        }
        return this.getContainerFromStore(extensionContext).select(parameterContext.getParameter().getType(), qualifiers.toArray(new Annotation[qualifiers.size()])).isResolvable();
    }

    private List<Annotation> resolveQualifiers(ParameterContext pc, BeanManager bm) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        if (pc.getParameter().getAnnotations().length == 0) {
            return Collections.emptyList();
        }
        for (Annotation annotation : pc.getParameter().getAnnotations()) {
            if (!bm.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    private boolean methodRequiresExplicitParamInjection(ParameterContext pc) {
        for (Annotation annotation : pc.getDeclaringExecutable().getAnnotations()) {
            if (!annotation.annotationType().equals(ExplicitParamInjection.class)) continue;
            return true;
        }
        return false;
    }

    private TestInstance.Lifecycle determineTestLifecycle(ExtensionContext ec) {
        TestInstance annotation = ec.getRequiredTestClass().getAnnotation(TestInstance.class);
        if (annotation != null) {
            return annotation.value();
        }
        return TestInstance.Lifecycle.PER_METHOD;
    }

    private void storeExplicitParamResolutionInformation(ExtensionContext ec) {
        Boolean globalSettings = Boolean.valueOf(System.getProperty(GLOBAL_EXPLICIT_PARAM_INJECTION));
        if (globalSettings.booleanValue()) {
            this.getStore(ec).put((Object)EXPLICIT_PARAM_INJECTION, (Object)globalSettings);
            return;
        }
        for (Annotation annotation : ec.getRequiredTestClass().getAnnotations()) {
            if (!annotation.annotationType().equals(ExplicitParamInjection.class)) continue;
            this.getStore(ec).put((Object)EXPLICIT_PARAM_INJECTION, (Object)true);
            break;
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestClass()}));
    }

    private WeldInitiator getInitiatorFromStore(ExtensionContext context) {
        return (WeldInitiator)((Object)this.getStore(context).get((Object)INITIATOR, WeldInitiator.class));
    }

    private Boolean getExplicitInjectionInfoFromStore(ExtensionContext context) {
        Boolean result = (Boolean)this.getStore(context).get((Object)EXPLICIT_PARAM_INJECTION, Boolean.class);
        return result == null ? false : result;
    }

    private WeldContainer getContainerFromStore(ExtensionContext context) {
        return (WeldContainer)this.getStore(context).get((Object)CONTAINER, WeldContainer.class);
    }
}

