/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import org.jboss.weld.injection.ForwardingInjectionTarget;

public class TestInstanceInjectionExtension<T>
implements Extension {
    private static final AnnotationLiteral<Singleton> SINGLETON_LITERAL = new AnnotationLiteral<Singleton>(){};
    private Class<?> testClass;
    private T testInstance;

    TestInstanceInjectionExtension(T testInstance) {
        this.testClass = testInstance.getClass();
        this.testInstance = testInstance;
    }

    void rewriteTestClassScope(@Observes ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        if (pat.getAnnotatedType().getJavaClass().equals(this.testClass)) {
            pat.configureAnnotatedType().add(SINGLETON_LITERAL);
        }
    }

    void rewriteTestInstanceInjectionTarget(@Observes ProcessInjectionTarget<T> pit) {
        if (pit.getAnnotatedType().getJavaClass().equals(this.testClass)) {
            pit.setInjectionTarget((InjectionTarget)new TestInstanceInjectionTarget(pit.getInjectionTarget()));
        }
    }

    private class TestInstanceInjectionTarget
    extends ForwardingInjectionTarget<T> {
        private InjectionTarget<T> injectionTarget;

        TestInstanceInjectionTarget(InjectionTarget<T> injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        protected InjectionTarget<T> delegate() {
            return this.injectionTarget;
        }

        public T produce(CreationalContext<T> creationalContext) {
            return TestInstanceInjectionExtension.this.testInstance;
        }
    }
}

