/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.junit5.ExtensionContextUtils;
import org.jboss.weld.junit5.WeldInitiator;
import org.jboss.weld.junit5.WeldJunit5Extension;
import org.jboss.weld.junit5.auto.ActivateScopes;
import org.jboss.weld.junit5.auto.ClassScanning;
import org.jboss.weld.junit5.auto.TestInstanceInjectionExtension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class WeldJunit5AutoExtension
extends WeldJunit5Extension {
    @Override
    protected void validateInitiator(List<Field> foundInitiatorFields) {
        if (foundInitiatorFields.size() > 0) {
            throw new IllegalStateException(foundInitiatorFields.stream().map(f -> String.format("Field '%s' with type %s which is in %s", f.getName(), f.getType(), f.getDeclaringClass())).collect(Collectors.joining("\n", "When using automagic mode, no @WeldSetup annotated field should be present! Fields found:\n", "")));
        }
    }

    @Override
    protected void weldInit(ExtensionContext context, Weld weld, WeldInitiator.Builder weldInitiatorBuilder) {
        List testInstances = context.getRequiredTestInstances().getAllInstances();
        List<Class<?>> testClasses = testInstances.stream().map(Object::getClass).collect(Collectors.toList());
        ClassScanning.scanForRequiredBeanClasses(testClasses, weld, ExtensionContextUtils.getExplicitInjectionInfoFromStore(context));
        Object outermostTestInstance = testInstances.get(0);
        weld.addBeanClasses(new Class[]{outermostTestInstance.getClass()});
        weld.addExtension(new TestInstanceInjectionExtension(outermostTestInstance));
        testClasses.stream().map(testClass -> AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)testClass, ActivateScopes.class)).flatMap(ann -> ann.stream().map(ActivateScopes::value)).forEach(x$0 -> {
            WeldInitiator.Builder cfr_ignored_0 = (WeldInitiator.Builder)weldInitiatorBuilder.activate((Class[])x$0);
        });
    }
}

