/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.Enhancement;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.weld.lite.extension.translator.AnnotationPresence;

class ExtensionPhaseEnhancementAction {
    private final Set<Class<?>> types;
    private final boolean withSubtypes;
    private final Set<Class<? extends Annotation>> withAnnotations;
    private final Consumer<ProcessAnnotatedType<?>> acceptor;

    ExtensionPhaseEnhancementAction(Set<Class<?>> types, boolean withSubtypes, Set<Class<? extends Annotation>> withAnnotations, Consumer<ProcessAnnotatedType<?>> acceptor) {
        this.types = types;
        this.withSubtypes = withSubtypes;
        this.withAnnotations = withAnnotations;
        this.acceptor = acceptor;
    }

    void run(ProcessAnnotatedType<?> pat) {
        if (this.satisfies(pat.getAnnotatedType())) {
            this.acceptor.accept(pat);
        }
    }

    private boolean satisfies(AnnotatedType<?> inspectedAnnotatedType) {
        Class inspectedClass = inspectedAnnotatedType.getJavaClass();
        if (this.types.contains(inspectedClass)) {
            return this.satisfiesAnnotationConstraints(inspectedAnnotatedType);
        }
        if (this.withSubtypes) {
            boolean typeMatches = false;
            for (Class<?> type : this.types) {
                if (!type.isAssignableFrom(inspectedClass)) continue;
                typeMatches = true;
                break;
            }
            return typeMatches && this.satisfiesAnnotationConstraints(inspectedAnnotatedType);
        }
        return false;
    }

    private boolean satisfiesAnnotationConstraints(AnnotatedType<?> annotatedType) {
        if (this.withAnnotations.contains(Enhancement.BeanDefiningAnnotations.class)) {
            return true;
        }
        return AnnotationPresence.allAnnotations(annotatedType).anyMatch(it -> {
            if (this.withAnnotations.contains(Annotation.class)) {
                return true;
            }
            return this.withAnnotations.contains(it.annotationType());
        });
    }
}

