/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.weld.lite.extension.translator.BeanInfoImpl;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionMethodParameterType;
import org.jboss.weld.lite.extension.translator.ExtensionPhase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseBase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistrationAction;
import org.jboss.weld.lite.extension.translator.InterceptorInfoImpl;
import org.jboss.weld.lite.extension.translator.ObserverInfoImpl;
import org.jboss.weld.lite.extension.translator.SharedErrors;
import org.jboss.weld.lite.extension.translator.TypesImpl;

class ExtensionPhaseRegistration
extends ExtensionPhaseBase {
    private final List<ExtensionPhaseRegistrationAction> actions;

    ExtensionPhaseRegistration(BeanManager beanManager, ExtensionInvoker util, SharedErrors errors, List<ExtensionPhaseRegistrationAction> actions) {
        super(ExtensionPhase.REGISTRATION, beanManager, util, errors);
        this.actions = actions;
    }

    @Override
    void runExtensionMethod(Method method) {
        Registration registration;
        Consumer<ProcessBean<?>> pbAcceptor;
        ExtensionMethodParameterType query;
        int numParameters = method.getParameterCount();
        int numQueryParameters = 0;
        ArrayList<ExtensionMethodParameterType> parameters = new ArrayList<ExtensionMethodParameterType>(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            ExtensionMethodParameterType parameter = ExtensionMethodParameterType.of(parameterType);
            parameters.add(parameter);
            if (parameter.isQuery()) {
                ++numQueryParameters;
            }
            parameter.verifyAvailable(ExtensionPhase.REGISTRATION, method);
        }
        if (numQueryParameters != 1) {
            String errorMsg = " of type BeanInfo or ObserverInfo for method " + method + " @ " + method.getDeclaringClass();
            if (numQueryParameters == 0) {
                throw new IllegalArgumentException("No parameter" + errorMsg);
            }
            if (numQueryParameters > 1) {
                throw new IllegalArgumentException("More than 1 parameter" + errorMsg);
            }
        }
        if ((query = parameters.stream().filter(ExtensionMethodParameterType::isQuery).findAny().get()) == ExtensionMethodParameterType.BEAN_INFO) {
            pbAcceptor = pb -> {
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument;
                    if (parameter.isQuery()) {
                        AnnotatedParameter disposer = null;
                        if (pb instanceof ProcessProducerField) {
                            disposer = ((ProcessProducerField)pb).getAnnotatedDisposedParameter();
                        } else if (pb instanceof ProcessProducerMethod) {
                            disposer = ((ProcessProducerMethod)pb).getAnnotatedDisposedParameter();
                        }
                        argument = new BeanInfoImpl(pb.getBean(), pb.getAnnotated(), disposer);
                    } else {
                        argument = this.argumentForExtensionMethod(parameter, method);
                    }
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), pbAcceptor, null));
        } else if (query == ExtensionMethodParameterType.INTERCEPTOR_INFO) {
            pbAcceptor = pb -> {
                if (!(pb.getBean() instanceof Interceptor)) {
                    return;
                }
                Interceptor cdiInterceptor = (Interceptor)pb.getBean();
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument = parameter.isQuery() ? new InterceptorInfoImpl(cdiInterceptor, pb.getAnnotated()) : this.argumentForExtensionMethod(parameter, method);
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), pbAcceptor, null));
        } else if (query == ExtensionMethodParameterType.OBSERVER_INFO) {
            Consumer<ProcessObserverMethod<?, ?>> pomAcceptor = pom -> {
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument = parameter.isQuery() ? new ObserverInfoImpl(pom.getObserverMethod(), pom.getAnnotatedMethod()) : this.argumentForExtensionMethod(parameter, method);
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), null, pomAcceptor));
        } else {
            throw new IllegalStateException("Unknown query parameter " + query);
        }
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameterType type, Method method) {
        if (type == ExtensionMethodParameterType.TYPES) {
            return new TypesImpl();
        }
        return super.argumentForExtensionMethod(type, method);
    }
}

