/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator.util.reflection;

import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedArrayTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedParameterizedTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypeVariableImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedWildcardTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.WildcardTypeImpl;

public final class AnnotatedTypes {
    private AnnotatedTypes() {
    }

    public static AnnotatedType from(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                int dimensions = 0;
                while (clazz.isArray()) {
                    ++dimensions;
                    clazz = clazz.getComponentType();
                }
                return AnnotatedTypes.array(clazz, dimensions);
            }
            return new AnnotatedTypeImpl(clazz);
        }
        if (type instanceof ParameterizedType) {
            return new AnnotatedParameterizedTypeImpl((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return new AnnotatedWildcardTypeImpl((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return new AnnotatedArrayTypeImpl((GenericArrayType)type);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static AnnotatedArrayType array(Type componentType, int dimensions) {
        GenericArrayTypeImpl type = new GenericArrayTypeImpl(componentType);
        for (int i = 0; i < dimensions - 1; ++i) {
            type = new GenericArrayTypeImpl(type);
        }
        return new AnnotatedArrayTypeImpl(type);
    }

    public static AnnotatedParameterizedType parameterized(Class<?> genericClass, Type ... typeArguments) {
        return new AnnotatedParameterizedTypeImpl(new ParameterizedTypeImpl(genericClass, typeArguments));
    }

    public static AnnotatedTypeVariable typeVariable(TypeVariable<?> typeVariable) {
        return new AnnotatedTypeVariableImpl(typeVariable);
    }

    public static AnnotatedWildcardType wildcardWithUpperBound(Type upperBound) {
        return new AnnotatedWildcardTypeImpl(WildcardTypeImpl.withUpperBound(upperBound));
    }

    public static AnnotatedWildcardType wildcardWithLowerBound(Type lowerBound) {
        return new AnnotatedWildcardTypeImpl(WildcardTypeImpl.withLowerBound(lowerBound));
    }

    public static AnnotatedWildcardType unboundedWildcardType() {
        return new AnnotatedWildcardTypeImpl(WildcardTypeImpl.unbounded());
    }
}

