/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jboss.weld.lite.extension.translator.SecurityActions;

class ReflectionMembers {
    static ConcurrentMap<Class<?>, Set<Method>> cachedMethods = new ConcurrentHashMap();
    static ConcurrentMap<Class<?>, Set<Field>> cachedFields = new ConcurrentHashMap();

    private ReflectionMembers() {
    }

    static Set<Method> allMethods(Class<?> clazz) {
        return cachedMethods.computeIfAbsent(clazz, ignored -> {
            HashSet result = new HashSet();
            ReflectionMembers.forEachSuperclass(clazz, it -> {
                Method[] methods = SecurityActions.getDeclaredMethods(it);
                result.addAll(Arrays.asList(methods));
            });
            return result;
        });
    }

    static Set<Field> allFields(Class<?> clazz) {
        return cachedFields.computeIfAbsent(clazz, ignored -> {
            HashSet result = new HashSet();
            ReflectionMembers.forEachSuperclass(clazz, it -> {
                Field[] fields = SecurityActions.getDeclaredFields(it);
                result.addAll(Arrays.asList(fields));
            });
            return result;
        });
    }

    static void clearCaches() {
        cachedMethods.clear();
        cachedFields.clear();
    }

    private static void forEachSuperclass(Class<?> clazz, Consumer<Class<?>> action) {
        HashSet<Class> alreadySeen = new HashSet<Class>();
        ArrayDeque workQueue = new ArrayDeque();
        workQueue.add(clazz);
        while (!workQueue.isEmpty()) {
            Class item = (Class)workQueue.remove();
            if (alreadySeen.contains(item)) continue;
            alreadySeen.add(item);
            Class superclass = item.getSuperclass();
            if (superclass != null && !Object.class.equals(superclass)) {
                workQueue.add(superclass);
            }
            workQueue.addAll(Arrays.asList(item.getInterfaces()));
            action.accept(item);
        }
    }
}

