/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.GetConstructorAction;
import org.jboss.weld.security.GetDeclaredConstructorsAction;
import org.jboss.weld.security.GetDeclaredFieldsAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.reflection.Reflections;

final class SecurityActions {
    private SecurityActions() {
    }

    static void ensureAccessible(AccessibleObject accessibleObject, Object declaringClassObject) {
        if (accessibleObject != null && !accessibleObject.canAccess(declaringClassObject)) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(SetAccessibleAction.of((AccessibleObject)accessibleObject));
            } else {
                accessibleObject.setAccessible(true);
            }
        }
    }

    static <T> Constructor<T> getConstructor(Class<T> javaClass) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Constructor)AccessController.doPrivileged(GetConstructorAction.of(javaClass, (Class[])new Class[0]));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getConstructor(new Class[0]);
    }

    static <T> Constructor<T>[] getDeclaredConstructors(Class<T> javaClass) {
        if (System.getSecurityManager() != null) {
            return (Constructor[])Reflections.cast(AccessController.doPrivileged(new GetDeclaredConstructorsAction(javaClass)));
        }
        return (Constructor[])Reflections.cast(javaClass.getDeclaredConstructors());
    }

    static Method[] getDeclaredMethods(Class<?> javaClass) {
        if (System.getSecurityManager() != null) {
            return (Method[])Reflections.cast(AccessController.doPrivileged(new GetDeclaredMethodsAction(javaClass)));
        }
        return (Method[])Reflections.cast((Object)javaClass.getDeclaredMethods());
    }

    static Field[] getDeclaredFields(Class<?> javaClass) {
        if (System.getSecurityManager() != null) {
            return (Field[])Reflections.cast(AccessController.doPrivileged(new GetDeclaredFieldsAction(javaClass)));
        }
        return (Field[])Reflections.cast((Object)javaClass.getDeclaredFields());
    }
}

