/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptionTypeRegistry;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.interceptor.proxy.InterceptorProxyCreatorImpl;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.registry.InterceptorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionUtils {
    private static final Log LOG = LogFactory.getLog(InterceptionUtils.class);
    public static final String POST_CONSTRUCT = "lifecycle_mixin_$$_postConstruct";
    public static final String PRE_DESTROY = "lifecycle_mixin_$$_preDestroy";
    private static Class<? extends Annotation> INTERCEPTORS_ANNOTATION_CLASS = null;
    private static Class<? extends Annotation> EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = null;

    public static void executePostConstruct(Object proxy) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_postConstruct();
        }
    }

    public static void executePredestroy(Object proxy) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_preDestroy();
        }
    }

    public static boolean isInterceptionCandidate(Method method) {
        int modifiers = method.getModifiers();
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (method.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType)) == null) continue;
            return false;
        }
        return !Modifier.isStatic(modifiers);
    }

    public static boolean isInterceptorMethod(InterceptionType interceptionType, Method method) {
        if (method.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType)) == null) {
            return false;
        }
        if (interceptionType.isLifecycleCallback()) {
            if (!Void.TYPE.equals(method.getReturnType())) {
                LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but does not have a void return type");
                return false;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 1) {
                LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but has more than 1 parameter");
                return false;
            }
            if (parameterTypes.length == 1 && !InvocationContext.class.equals(parameterTypes[0])) {
                LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but does not have a " + InvocationContext.class.getName() + " parameter ");
                return false;
            }
            return true;
        }
        if (!Object.class.equals(method.getReturnType())) {
            LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but does not return a " + Object.class.getName());
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but does not have exactly 1 parameter");
            return false;
        }
        if (!InvocationContext.class.equals(parameterTypes[0])) {
            LOG.warn("Method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " is annotated with " + interceptionType.getAnnotationClassName() + " but does not have a " + InvocationContext.class.getName() + " parameter ");
            return false;
        }
        return true;
    }

    public static <T> T proxifyInstance(T instance, Class<?> superClass, List<InterceptorRegistry<Class<?>, ?>> interceptorRegistries, List<InterceptionHandlerFactory<?>> interceptionHandlerFactory) {
        try {
            InterceptorProxyCreatorImpl proxyCreator = new InterceptorProxyCreatorImpl(interceptorRegistries, interceptionHandlerFactory);
            return (T)proxyCreator.createProxyFromInstance(instance, superClass);
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    public static <T> T proxifyInstance(T instance, Class<?> superClass, InterceptorRegistry<Class<?>, ?> interceptorRegistry, InterceptionHandlerFactory<?> interceptionHandlerFactory) {
        try {
            InterceptorProxyCreatorImpl proxyCreator = new InterceptorProxyCreatorImpl(Collections.singletonList(interceptorRegistry), Collections.singletonList(interceptionHandlerFactory));
            return (T)proxyCreator.createProxyFromInstance(instance, superClass);
        }
        catch (Exception e) {
            throw new InterceptorException(e);
        }
    }

    public static boolean supportsEjb3InterceptorDeclaration() {
        return INTERCEPTORS_ANNOTATION_CLASS != null && EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS != null;
    }

    public static Class<? extends Annotation> getInterceptorsAnnotationClass() {
        return INTERCEPTORS_ANNOTATION_CLASS;
    }

    public static Class<? extends Annotation> getExcludeClassInterceptorsAnnotationClass() {
        return EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;
    }

    static {
        try {
            INTERCEPTORS_ANNOTATION_CLASS = Class.forName("javax.interceptor.Interceptors");
            EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = Class.forName("javax.interceptor.ExcludeClassInterceptors");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

