/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import javassist.util.proxy.ProxyFactory;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.proxy.ClientProxyMethodHandler;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyProvider {
    private static final long serialVersionUID = 9029999149357529341L;
    private final ConcurrentCache<Bean<? extends Object>, Object> pool = new ConcurrentCache();

    private static <T> T createClientProxy(Bean<T> bean, BeanManagerImpl manager, int beanIndex) throws RuntimeException {
        try {
            ClientProxyMethodHandler proxyMethodHandler = new ClientProxyMethodHandler(bean, manager, beanIndex);
            LinkedHashSet<Type> classes = new LinkedHashSet<Type>(bean.getTypes());
            classes.add((Type)((Object)Serializable.class));
            ProxyFactory proxyFactory = Proxies.getProxyFactory(classes);
            proxyFactory.setHandler(proxyMethodHandler);
            Class clazz = proxyFactory.createClass();
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate client proxy for " + bean, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating client proxy for " + bean, e);
        }
    }

    public <T> T getClientProxy(final BeanManagerImpl manager, final Bean<T> bean) {
        Object instance = this.pool.putIfAbsent(bean, new Callable<T>(){

            @Override
            public T call() throws Exception {
                int beanIndex = manager.getBeans().indexOf(bean);
                if (beanIndex < 0) {
                    throw new DefinitionException(bean + " is not known to the manager");
                }
                return ClientProxyProvider.createClientProxy(bean, manager, beanIndex);
            }
        });
        return (T)instance;
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }
}

