/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.ee.EEResourceProducerField;
import org.jboss.weld.bean.ee.PersistenceContextProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.events.ProcessBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessInjectionTargetImpl;
import org.jboss.weld.bootstrap.events.ProcessManagedBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerFieldImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessSessionBeanImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.jsf.JsfApiAbstraction;
import org.jboss.weld.log.LogProvider;
import org.jboss.weld.log.Logging;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.servlet.ServletApiAbstraction;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private static final LogProvider log = Logging.getLogProvider(AbstractBeanDeployer.class);
    private final BeanManagerImpl manager;
    private final E environment;

    public AbstractBeanDeployer(BeanManagerImpl manager, E environment) {
        this.manager = manager;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public AbstractBeanDeployer<E> deploy() {
        Set<RIBean<?>> beans = ((BeanDeployerEnvironment)this.getEnvironment()).getBeans();
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.manager.addDecorator(decoratorImpl);
            log.debug("Bean: " + decoratorImpl);
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.manager.addInterceptor(interceptorImpl);
            log.debug("Interceptor: " + interceptorImpl);
        }
        for (RIBean rIBean : beans) {
            rIBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            if (!(rIBean instanceof NewBean)) {
                if (rIBean instanceof AbstractProducerBean) {
                    ProcessProducerImpl.fire(this.manager, (AbstractProducerBean)rIBean);
                } else if (rIBean instanceof AbstractClassBean) {
                    ProcessInjectionTargetImpl.fire(this.manager, (AbstractClassBean)rIBean);
                }
                if (rIBean instanceof ManagedBean) {
                    ProcessManagedBeanImpl.fire(this.manager, (ManagedBean)rIBean);
                } else if (rIBean instanceof SessionBean) {
                    ProcessSessionBeanImpl.fire(this.manager, (SessionBean)rIBean);
                } else if (rIBean instanceof ProducerField) {
                    ProcessProducerFieldImpl.fire(this.manager, (ProducerField)rIBean);
                } else if (rIBean instanceof ProducerMethod) {
                    ProcessProducerMethodImpl.fire(this.manager, (ProducerMethod)rIBean);
                } else {
                    ProcessBeanImpl.fire(this.getManager(), rIBean);
                }
            }
            this.manager.addBean(rIBean);
            log.debug("Bean: " + rIBean);
        }
        for (ObserverMethodImpl observerMethodImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            log.debug("Observer : " + observerMethodImpl);
            observerMethodImpl.initialize();
            ProcessObserverMethodImpl.fire(this.manager, observerMethodImpl);
            this.manager.addObserver(observerMethodImpl);
        }
        return this;
    }

    protected <T> void createSubBeans(AbstractClassBean<T> bean) {
        this.createProducerMethods((AbstractClassBean)bean, (WeldClass)bean.getAnnotatedItem());
        this.createProducerFields((AbstractClassBean)bean, (WeldClass)bean.getAnnotatedItem());
        if (this.manager.isBeanEnabled(bean)) {
            this.createObserverMethods((RIBean)bean, (WeldClass)bean.getAnnotatedItem());
        }
        this.createDisposalMethods((AbstractClassBean)bean, (WeldClass)bean.getAnnotatedItem());
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredAnnotatedWeldMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethod<X, ?> disposalBean = DisposalMethod.of(this.manager, method, declaringBean);
            disposalBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ((BeanDeployerEnvironment)this.getEnvironment()).addBean(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, WeldMethod<T, X> annotatedMethod) {
        ProducerMethod<X, T> bean = ProducerMethod.of(annotatedMethod, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, WeldField<T, X> field) {
        ProducerField bean = this.isPersistenceContextProducerField(field) ? PersistenceContextProducerField.of(field, declaringBean, this.manager) : (this.isEEResourceProducerField(field) ? EEResourceProducerField.of(field, declaringBean, this.manager) : ProducerField.of(field, declaringBean, this.manager));
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldField<?, X> field : annotatedClass.getDeclaredAnnotatedWeldFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    protected <X, T> void createObserverMethod(RIBean<X> declaringBean, WeldMethod<T, X> method) {
        ObserverMethodImpl<X, T> observer = ObserverFactory.create(method, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserver(observer);
    }

    protected <T> void createSimpleBean(WeldClass<T> annotatedClass) {
        ManagedBean<T> bean = ManagedBean.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
        this.createSubBeans(bean);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(NewManagedBean.of(annotatedClass, this.manager));
    }

    protected <T> void createDecorator(WeldClass<T> annotatedClass) {
        DecoratorImpl<T> bean = DecoratorImpl.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
    }

    protected <T> void createInterceptor(WeldClass<T> annotatedClass) {
        InterceptorImpl<T> bean = InterceptorImpl.of(annotatedClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
    }

    protected <T> void createEnterpriseBean(InternalEjbDescriptor<T> ejbDescriptor) {
        SessionBean<T> bean = SessionBean.of(ejbDescriptor, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(bean);
        this.createSubBeans(bean);
        ((BeanDeployerEnvironment)this.getEnvironment()).addBean(NewSessionBean.of(ejbDescriptor, this.manager));
    }

    protected boolean isTypeManagedBeanOrDecorator(WeldClass<?> clazz) {
        Class javaClass = clazz.getJavaClass();
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        JsfApiAbstraction jsfApiAbstraction = this.manager.getServices().get(JsfApiAbstraction.class);
        ServletApiAbstraction servletApiAbstraction = this.manager.getServices().get(ServletApiAbstraction.class);
        return !clazz.isNonStaticMemberClass() && !Reflections.isParamerterizedTypeWithWildcard(javaClass) && !servletApiAbstraction.SERVLET_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.FILTER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(javaClass) && !ejbApiAbstraction.ENTERPRISE_BEAN_CLASS.isAssignableFrom(javaClass) && !jsfApiAbstraction.UICOMPONENT_CLASS.isAssignableFrom(javaClass) && AbstractBeanDeployer.hasSimpleWebBeanConstructor(clazz);
    }

    protected boolean isEEResourceProducerField(WeldField<?, ?> field) {
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = this.manager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    protected boolean isPersistenceContextProducerField(WeldField<?, ?> field) {
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        return field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS);
    }

    private static boolean hasSimpleWebBeanConstructor(WeldClass<?> type) {
        return type.getNoArgsWeldConstructor() != null || type.getAnnotatedWeldConstructors(Inject.class).size() > 0;
    }

    public E getEnvironment() {
        return this.environment;
    }
}

