/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiAbstraction {
    private static final Class<DummyAnnotation> DUMMY_ANNOTATION = DummyAnnotation.class;
    private static final Class<Dummy> DUMMY_CLASS = Dummy.class;
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private ResourceLoader resourceLoader;

    public ApiAbstraction(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Class<? extends Annotation> annotationTypeForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_ANNOTATION;
        }
    }

    protected Class<?> classForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_CLASS;
        }
    }

    protected Object enumValue(Class<?> clazz, String memberName) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(clazz + " is not an enum!");
        }
        try {
            return clazz.getField(memberName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DummyEnum {
        DUMMY_VALUE;

    }

    public static interface Dummy {
    }

    public static @interface DummyAnnotation {
    }
}

