/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.AbstractSessionBeanStore;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

public class LazySessionBeanStore
extends AbstractSessionBeanStore {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final HttpServletRequest request;

    public LazySessionBeanStore(HttpServletRequest request, NamingScheme namingScheme) {
        super(namingScheme);
        this.request = request;
        log.trace("Loading bean store " + this + " map from session " + this.getSession(false));
    }

    protected HttpSession getSessionIfExists() {
        return this.request.getSession(false);
    }

    @Override
    protected HttpSession getSession(boolean create) {
        try {
            return this.request.getSession(create);
        }
        catch (IllegalStateException e) {
            this.detach();
            return null;
        }
    }
}

