/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.jlr.AbstractWeldMember;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

public class WeldFieldImpl<T, X>
extends AbstractWeldMember<T, X, Field>
implements WeldField<T, X> {
    private final Field field;

    public static <T, X> WeldFieldImpl<T, X> of(String contextId, Field field, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        return new WeldFieldImpl<T, X>(contextId, field, (Class)Reflections.cast(field.getType()), field.getGenericType(), new TypeClosureLazyValueHolder(contextId, field.getGenericType()), WeldFieldImpl.buildAnnotationMap(field.getAnnotations()), WeldFieldImpl.buildAnnotationMap(field.getDeclaredAnnotations()), declaringClass, classTransformer);
    }

    public static <X> WeldFieldImpl<?, X> of(String contextId, AnnotatedField<? super X> annotatedField, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        return new WeldFieldImpl(contextId, annotatedField.getJavaMember(), (Class)Reflections.cast(annotatedField.getJavaMember().getType()), annotatedField.getBaseType(), new TypeClosureLazyValueHolder(contextId, annotatedField.getTypeClosure()), WeldFieldImpl.buildAnnotationMap(annotatedField.getAnnotations()), WeldFieldImpl.buildAnnotationMap(annotatedField.getAnnotations()), declaringClass, classTransformer);
    }

    private WeldFieldImpl(String contextId, Field field, Class<T> rawType, Type type, LazyValueHolder<Set<Type>> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        super(contextId, annotationMap, declaredAnnotationMap, classTransformer, field, rawType, type, typeClosure, declaringClass);
        this.field = field;
    }

    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        SecureReflections.ensureAccessible(this.field).set(instance, value);
    }

    public void setOnInstance(Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        SecureReflections.getField(instance.getClass(), this.getName()).set(instance, value);
    }

    @Override
    public T get(Object instance) {
        try {
            return Reflections.cast(SecureReflections.ensureAccessible(this.getDelegate()).get(instance));
        }
        catch (Exception e) {
            throw new WeldException(UtilMessage.ACCESS_ERROR_ON_FIELD, (Throwable)e, this.getDelegate().getName(), this.getDelegate().getDeclaringClass());
        }
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public String toString() {
        return "[field] " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(this.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(((Field)this.getJavaMember()).getModifiers())) + this.getDeclaringType().getName() + "." + this.getName();
    }

    @Override
    public boolean isGeneric() {
        return false;
    }
}

