/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

public class ClassLoaderResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> classForName(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, e);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    @Override
    public Collection<URL> getResources(String name) {
        try {
            return new EnumerationList<URL>(this.classLoader.getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, e);
        }
    }

    @Override
    public void cleanup() {
        this.classLoader = null;
    }
}

